<?php

define("SBLAM_API_KEY",NULL);

if (!defined('IN_PHPBB'))
{
	die("Sblam: Kod wtyczki nie jest umieszczony w odpowiednim miejscu. Zobacz http://sblam.com/phpbb/");
}

require_once dirname(__FILE__)."/sblamtest.php";

function sblam_register_hook(&$error,&$error_msg,$mode)
{
	global $board_config,$lang;
	
	if (!$error && $mode == 'register')
	{
		$spam = sblamtestpost(NULL,SBLAM_API_KEY);
	
		// definitely a spam, reject registration
		if ($spam == 2)
		{
			$error = TRUE;
			$error_msg = isset($lang['Spam_registration'])?$lang['Spam_registration']:"Rejestracja zablokowana przez filtr antyspamowy! ";
			$error_msg .= ' <a href="'.sblamreporturl().'">'.(isset($lang['Spam_report'])?$lang['Spam_report']:"Poinformuj o pomy&#x142;ce").'</a>.';
		}
		// either likely spam or fatal error, let admin decide
		elseif ($spam >= 0)
		{
			$board_config['require_activation'] = USER_ACTIVATION_ADMIN;
		}
		// probably not spam, but unsure, let user confirm
		elseif ($spam == -1)
		{
			if ($board_config['require_activation'] != USER_ACTIVATION_ADMIN) 
			{
				$board_config['require_activation'] = USER_ACTIVATION_SELF;
			}
		}
	}
}

function sblam_posting_hook($mode, $post_username, $bbcode_uid, $post_subject, $post_message)
{
	global $lang;
	
	if ($mode == 'newtopic' || $mode == 'editpost' || $mode == 'reply')
	{
		$_POST['sblambb_content'] = str_replace($bbcode_uid,' ',"$post_subject\n\n$post_message");
		$_POST['sblambb_username'] = $post_username;
		$spam = sblamtestpost(array('sblambb_content','sblambb_username',NULL,NULL),SBLAM_API_KEY);
		unset($_POST['sblambb_content']);
		unset($_POST['sblambb_username']);
		
		if ($spam == 2 || ($mode == 'newtopic' && $spam > 0))
		{
			$message = isset($lang['Spam_posting'])?$lang['Spam_posting']:"Post odrzucony przez filtr antyspamowy!";
			$message .= ' <a href="'.sblamreporturl().'">'.(isset($lang['Spam_report'])?$lang['Spam_report']:"Poinformuj o pomy&#x142;ce").'</a>.';
			message_die(GENERAL_MESSAGE, $message);
			return true;
		}
	}
}
