/*
 * TervisView.java
 */
package tervis;

import javax.swing.event.ChangeEvent;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

/**
 * The application's main frame.
 */
public class TervisView extends FrameView {
	public TervisView(SingleFrameApplication app) {
		super(app);

		initComponents();

		// status bar initialization - message timeout, idle icon and busy animation, etc
		ResourceMap resourceMap = getResourceMap();
		int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
		messageTimer = new Timer(messageTimeout, new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			}
		});
		messageTimer.setRepeats(false);
		int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
		for (int i = 0; i < busyIcons.length; i++) {
			busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
		}
		busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
			}
		});

		// connecting action tasks to status bar via TaskMonitor
		TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
		taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
			public void propertyChange(java.beans.PropertyChangeEvent evt) {
				String propertyName = evt.getPropertyName();
				if ("started".equals(propertyName)) {
					if (!busyIconTimer.isRunning()) {
						busyIconIndex = 0;
						busyIconTimer.start();
					}
				} else if ("done".equals(propertyName)) {
					busyIconTimer.stop();
				} else if ("message".equals(propertyName)) {
					String text = (String) (evt.getNewValue());
					messageTimer.restart();
				} else if ("progress".equals(propertyName)) {
					int value = (Integer) (evt.getNewValue());
				}
			}
		});

		init();
	}

	@Action
	public void showAboutBox() {
		if (aboutBox == null) {
			JFrame mainFrame = TervisApp.getApplication().getMainFrame();
			aboutBox = new TervisAboutBox(mainFrame);
			aboutBox.setLocationRelativeTo(mainFrame);
		}
		TervisApp.getApplication().show(aboutBox);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        g_speed = new javax.swing.JMenuItem();
        g_specfy = new javax.swing.JMenuItem();
        g_shuffle = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        g_shell = new javax.swing.JMenuItem();
        g_quick = new javax.swing.JMenuItem();
        g_wut = new javax.swing.JMenuItem();
        g_ed = new javax.swing.JMenuItem();
        g_bubble = new javax.swing.JMenuItem();
        g_stooge = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                exec_resize(evt);
            }
        });

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 279, Short.MAX_VALUE)
        );

        menuBar.setName("menuBar"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(tervis.TervisApp.class).getContext().getResourceMap(TervisView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(tervis.TervisApp.class).getContext().getActionMap(TervisView.class, this);
        g_speed.setAction(actionMap.get("exec_speed")); // NOI18N
        g_speed.setText(resourceMap.getString("g_speed.text")); // NOI18N
        g_speed.setName("g_speed"); // NOI18N
        fileMenu.add(g_speed);

        g_specfy.setAction(actionMap.get("exec_specify")); // NOI18N
        g_specfy.setText(resourceMap.getString("g_specfy.text")); // NOI18N
        g_specfy.setName("g_specfy"); // NOI18N
        fileMenu.add(g_specfy);

        g_shuffle.setAction(actionMap.get("exec_shuffle")); // NOI18N
        g_shuffle.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0));
        g_shuffle.setText(resourceMap.getString("g_shuffle.text")); // NOI18N
        g_shuffle.setName("g_shuffle"); // NOI18N
        fileMenu.add(g_shuffle);

        jSeparator1.setName("jSeparator1"); // NOI18N
        fileMenu.add(jSeparator1);

        g_shell.setAction(actionMap.get("exec_shell")); // NOI18N
        g_shell.setText(resourceMap.getString("g_shell.text")); // NOI18N
        g_shell.setName("g_shell"); // NOI18N
        fileMenu.add(g_shell);

        g_quick.setAction(actionMap.get("exec_quick")); // NOI18N
        g_quick.setText(resourceMap.getString("g_quick.text")); // NOI18N
        g_quick.setName("g_quick"); // NOI18N
        fileMenu.add(g_quick);

        g_wut.setAction(actionMap.get("exec_wut")); // NOI18N
        g_wut.setText(resourceMap.getString("g_wut.text")); // NOI18N
        g_wut.setName("g_wut"); // NOI18N
        fileMenu.add(g_wut);

        g_ed.setAction(actionMap.get("exec_ed")); // NOI18N
        g_ed.setText(resourceMap.getString("g_ed.text")); // NOI18N
        g_ed.setName("g_ed"); // NOI18N
        fileMenu.add(g_ed);

        g_bubble.setAction(actionMap.get("exec_bubble")); // NOI18N
        g_bubble.setText(resourceMap.getString("g_bubble.text")); // NOI18N
        g_bubble.setName("g_bubble"); // NOI18N
        fileMenu.add(g_bubble);

        g_stooge.setAction(actionMap.get("exec_stooge")); // NOI18N
        g_stooge.setText(resourceMap.getString("g_stooge.text")); // NOI18N
        g_stooge.setName("g_stooge"); // NOI18N
        fileMenu.add(g_stooge);

        jSeparator2.setName("jSeparator2"); // NOI18N
        fileMenu.add(jSeparator2);

        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        setComponent(mainPanel);
        setMenuBar(menuBar);
    }// </editor-fold>//GEN-END:initComponents
	/**
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 *
	 * This is where my own code starts!
	 */
	int[] items;
	Graph graph;
	final int COLUMNS = 16;

	/**
	 * Some sort of constructor for my own code
	 */
	void init() {
		items = new int[COLUMNS];
		graph = new Graph(mainPanel);
		exec_shuffle();
	}

	/**
	 * The window changed size; redraw the graph
	 */
	private void exec_resize(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_exec_resize
		graph.draw(items);
	}//GEN-LAST:event_exec_resize

	/**
	 * User clicked [esc], shuffle stuff
	 */
	@Action
	public void exec_shuffle() {
		// Create an arraylist with all possible values
		ArrayList<Integer> bin = new ArrayList<Integer>();
		for (int a = 0; a < items.length; a++) {
			bin.add(a + 1);
		}
		// Remove a random value from the pool of items,
		// thus getting a "true" random list with no dupes
		for (int a = items.length; a > 0; a--) {
			items[a - 1] = bin.remove(Toolkit.rand(bin.size()));
		}
		//items = new int[] { 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
		graph.draw(items);
	}

	@Action
	public void exec_specify() {
		try {
			// Query user for values
			String var = javax.swing.JOptionPane.showInputDialog(
				"Space separated values", itemsToString());

			// Filter double spaces
			while (var.contains("  "))
				var = var.replace("  ", " ");

			// Trim whitespace and split
			String[] vars = var.trim().split("\\ ");

			// Parse the values
			items = new int[vars.length];
			for (int a = 0; a < vars.length; a++) {
				items[a] = Integer.parseInt(vars[a]);
			}
			graph.draw(items);
		} catch (Exception ex) {
			javax.swing.JOptionPane.showMessageDialog(null,
				"It is pitch black. You are likely to be eaten by a Grue.");
		}
	}

	/**
	 * Convert itemlist to string
	 */
	private String itemsToString() {
		StringBuilder sbo = new StringBuilder();
		for (int i : items) {
			sbo.append(i + " ");
		}
		return sbo.toString();
	}

	@Action
	public void exec_shell() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- En av de bedre algoritmene\n"
			+ "- Feilfri visualisering",
			"Shellsort", 1);
		new SortShell(graph, items).start();
	}

	@Action
	public void exec_quick() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- Generellt sett best\n"
			+ "- Noe glitchy visualisering",
			"Quicksort", 1);
		new SortQuick(graph, items).start();
	}

	@Action
	public void exec_wut() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- Sammenlikner tilfeldige verdier\n"
			+ "- Feilfri visualisering",
			"Wutsort", 1);
		new SortWut(graph, items).start();
	}

	@Action
	public void exec_ed() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- O(n²), eksentrisk fremgangsmåte\n"
			+ "- Feilfri visualisering",
			"edSort", 1);
		new SortEd(graph, items).start();
	}

	@Action
	public void exec_bubble() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- Ikke akkurat raskest...\n"
			+ "- Feilfri visualisering",
			"Bubblesort", 1);
		new SortBubble(graph, items).start();
	}

	@Action
	public void exec_stooge() {
		javax.swing.JOptionPane.showMessageDialog(null,
			"- Gammel og elendig.\n"
			+ "- Feilfri visualisering",
			"Stoogesort", 1);
		new SortStooge(graph, items).start();
	}

	/**
	 * Set GUI speed using a JSlider
	 */
	@Action
	public void exec_speed() {

		// Create a new form and slider
		javax.swing.JFrame jf = new JFrame("Set speed");
		final javax.swing.JSlider js = new JSlider(
			1, 500, 500 - graph.getDelay());

		// Create the "value changed" listener
		js.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				graph.setDelay(500 - js.getValue());
				// Updates the graph instance
			}
		});
		jf.add(js);
		jf.setSize(320, 96);
		jf.setVisible(true);
	}
	/*
	 * EOF
	 */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem g_bubble;
    private javax.swing.JMenuItem g_ed;
    private javax.swing.JMenuItem g_quick;
    private javax.swing.JMenuItem g_shell;
    private javax.swing.JMenuItem g_shuffle;
    private javax.swing.JMenuItem g_specfy;
    private javax.swing.JMenuItem g_speed;
    private javax.swing.JMenuItem g_stooge;
    private javax.swing.JMenuItem g_wut;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    // End of variables declaration//GEN-END:variables
	private final Timer messageTimer;
	private final Timer busyIconTimer;
	private final Icon[] busyIcons = new Icon[15];
	private int busyIconIndex = 0;
	private JDialog aboutBox;
}
