/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package tervis;

public class SortWut extends Sort {
	public SortWut(Graph graph, int[] items) {
		super(graph, items);
	}

	/**
	 * Executes Ohgodwhatsort
	 * The result of a lighthearted discussion
	 * Comments are basically what was being said at the time
	 */
	@Override
	public void doSort() {
		while (!isSorted()) {

			// This algo is so bad it doesn't even know
			// whether it's finished sorting yet or not!
			for (int i = 0; i < items.length * 4; i++) {

				// Pick two numbers at random
				int a = Toolkit.rand(items.length);
				int b = Toolkit.rand(items.length);
				if (a > b) {

					// Make sure the lowest
					// indice comes first
					int c = a;
					a = b;
					b = c;
				}
				graph.increase(1, 0);
				if (items[a] > items[b]) {
					graph.increase(0, 1);
					graph.hilight(a, b);

					// Value on lower indice is higher;
					// swap these for a slightly more
					// sorted collection~
					int c = items[a];
					items[a] = items[b];
					items[b] = c;
					graph.swap(a, b);
					graph.draw(items);
				}
			}
		}
	}
}
