/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package tervis;

public class SortStooge extends Sort {
	public SortStooge(Graph graph, int[] items) {
		super(graph, items);
	}

	/**
	 * Executes Stooge sort
	 * Suggested by johndarc@geeteevee
	 * Comments from own understanding of the code
	 */
	@Override
	public void doSort() {
		stooge(0, items.length - 1);
	}

	/**
	 * The actual algorithm
	 * @param lo array lower bound
	 * @param hi array upper bound
	 */
	private void stooge(int lo, int hi) {
		graph.increase(1, 0);

		// If the lower value is higher than the upper...
		if (items[lo] > items[hi]) {
			graph.increase(0, 1);
			graph.hilight(lo, hi);

			// ...swap the values
			int tmp = items[lo];
			items[lo] = items[hi];
			items[hi] = tmp;
			graph.swap(lo, hi);
			graph.draw(items);
		}
		// If there are values inbetween:
		if (hi - lo > 1) {
			int t = (hi - lo + 1) / 3;

			// Sort the first third
			stooge(lo, hi - t);

			// Sort the last third
			stooge(lo + t, hi);

			// This glaring redundancy is killing me
			stooge(lo, hi - t);
		}
	}
}
