/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package tervis;

public class SortShell extends Sort {
	public SortShell(Graph graph, int[] items) {
		super(graph, items);
	}

	/**
	 * Executes Shellsort
	 * Algorithm based on wikipedia pseudocode
	 * Comments from own understanding of the code
	 */
	@Override
	public void doSort() {

		// Some temporary values
		int temp, j;

		// Comparison starts at the middle half
		int inc = (int) Math.round(items.length / 2.0);

		// Implies we'll be moving towards the beginning
		while (inc > 0) {

			// Compare values from this inc towards end
			for (int i = inc; i < items.length; i++) {
				j = i;
				temp = items[i];
				graph.increase(1, 0);

				// Move item j towards the start as long as the
				// prev. value is larger; thus sorting the array
				while (j >= inc && items[j - inc] > temp) {
					graph.increase(1, 1);
					graph.hilight(j, j - inc, i);
					items[j] = items[j - inc];
					j = j - inc;
				}

				// Value is now where it should be;
				// increase the moves counter.
				if (items[j] != temp) {
					items[j] = temp;
					graph.increase(0, 1);
					graph.swap(i, j);
					graph.draw(items);
				}
			}

			// What's up with the magic numbers ;_;
			inc = (int) Math.round(inc / 2.2);
		}
	}
}
