/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package tervis;

import java.util.ArrayList;

public class SortQuick extends Sort {
	public SortQuick(Graph graph, int[] items) {
		super(graph, items);
	}

	@Override
	public void doSort() {
		ArrayList<Integer> vars = new ArrayList<Integer>();
		for (int i : items)
			vars.add(i);

		ArrayList<Integer> sorted = quicksort(vars, 0);
		for (int a = 0; a < items.length; a++) {
			items[a] = sorted.get(a);
		}
	}

	/**
	 * The quicksort algorithm; modified to visualize sorting progress.
	 * @param vars the values to sort
	 * @param lo offset of this set relative to the original array
	 * @return the sorted (sub)set
	 */
	private ArrayList<Integer> quicksort(ArrayList<Integer> vars, int lo) {
		if (vars.size() < 2)
			// All sorted!
			return vars;

		ArrayList<Integer> //
			less = new ArrayList<Integer>(),
			greater = new ArrayList<Integer>(),
			result = new ArrayList<Integer>();

		// Select the pivot and dump the rest into less/greater
		int pivot = vars.remove(vars.size() / 2);
		for (int i : vars) {
			if (i <= pivot) {
				less.add(i);
			} else {
				greater.add(i);
			}
		}

		// Display the current state
		ArrayList<Integer> cur = new ArrayList<Integer>();
		cur.addAll(less);
		cur.add(pivot);
		cur.addAll(greater);
		draw(cur, lo);

		// Recursively continue sorting (lower half)
		result.addAll(quicksort(less, lo));

		// Add the pivot to the sorted set
		result.add(pivot);

		// Recursively sort upper half; relative offset += less.size + pivot
		result.addAll(quicksort(greater, less.size() + lo + 1));

		return result;
	}

	private void draw(ArrayList<Integer> vars, int lo) {
		// The best visualization effect
		// I can pull off for quicksort ;_;
		for (int a = 0; a < vars.size(); a++) {
			System.out.println("Echo " + lo + "->" + vars.size());
			items[a + lo] = vars.get(a);
		}
		graph.draw(items);
	}
}
