/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

package tervis;

public class SortBubble extends Sort {
	public SortBubble(Graph graph, int[] items) {
		super(graph, items);
	}

	/**
	 * Executes Bubblesort
	 * Because I wanted to see how it compared to the other algorithms
	 * Comments from own understanding of the code
	 */
	@Override
	public void doSort() {
		boolean done = false;
		while (!done) {
			done = true;

			// Iterate the array from 1 to end
			for (int a = 1; a < items.length; a++) {
				graph.increase(1, 0);

				// Are these two items in order?
				if (items[a-1] > items[a]) {

					// No, swap them
					graph.increase(0, 1);
					graph.hilight(a-1, a);
					graph.swap(a-1, a);

					int tmp = items[a];
					items[a] = items[a-1];
					items[a-1] = tmp;
					graph.draw(items);

					// Still nto done
					done = false;
				}
			}
		}
	}
}
