/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package tervis;

public class Sort extends Thread {
	protected int[] items;
	protected Graph graph;

	/**
	 * Initialize everything
	 * @param graph graph to use
	 * @param items items to sort
	 */
	public Sort(Graph graph, int[] items) {
		this.graph = graph;
		this.items = items;
		graph.reset();
	}

	/**
	 * Sorting algorithm to apply.
	 */
	public void doSort() {
		// OVERRIDE ME
	}

	/**
	 * Thread kicker
	 */
	@Override
	public void run() {
		doSort();
		graph.draw(items);
		graph.extremerice();
	}

	/**
	 * Checks whether the list is sorted.
	 * Counts towards the comparison counter.
	 * @return take a guess
	 */
	protected boolean isSorted() {
		for (int a = 1; a < items.length; a++) {
			graph.increase(1, 0);
			if (items[a - 1] > items[a])
				return false;
		}
		return true;
	}
}
