package oblig02;

import java.util.ArrayList;
public class StatsBuilder {

	ArrayList<Enumerator> types;
	ArrayList<Enumerator> owners;
	ArrayList<Enumerator> ownersc;
	int lotsTotal;
	int cstrTotal;
	int lotsSold;

	public StatsBuilder() {
		types = new ArrayList<Enumerator>();
		owners = new ArrayList<Enumerator>();
		ownersc = new ArrayList<Enumerator>();
		lotsTotal = 0;
		cstrTotal = 0;
		lotsSold = 0;
	}

	public StatsBuilder(LotMan lot) {
		this();
		add(lot.getLots());
		order();
	}

	public void add(Lot[][] lot) {
		for (int y = 0; y < lot.length; y++) {
			for (int x = 0; x < lot[y].length; x++) {
				if (lot[y][x] != null) {
					add(lot[y][x]);
					lotsSold++;
				}
				lotsTotal++;
			}
		}
	}

	public void add(Lot lot) {
		add(types, lot.type);
		add(owners, lot.owner);
		if (lot.type.length() > 0) {
			add(ownersc, lot.owner);
			cstrTotal++;
		}
	}

	void add(ArrayList<Enumerator> alenum, String value) {
		add(alenum, value, 1);
	}

	void add(ArrayList<Enumerator> alenum, String value, int count) {
		if (value.length() == 0) {
			return;
		}
		for (int a = 0; a < alenum.size(); a++) {
			if (alenum.get(a).matches(value)) {
				alenum.get(a).inc(count);
				return;
			}
		}
		alenum.add(new Enumerator(value, count));
	}

	public void order() {
		ownersc = Mergesort.sort(ownersc);
		owners = Mergesort.sort(owners);
		types = Mergesort.sort(types);
	}

	Enumerator[] getEnumerator(ArrayList<Enumerator> alenu) {
		Enumerator[] ret = new Enumerator[alenu.size()];
		for (int a = 0; a < ret.length; a++) {
			ret[a] = alenu.get(a);
		}
		Helper.flipArray(ret);
		return ret;
	}

	public int getLotsTotal() {
		return lotsTotal;
	}

	public int getCstrTotal() {
		return cstrTotal;
	}

	public int getLotsSold() {
		return lotsSold;
	}

	public Enumerator[] getOwners() {
		return getEnumerator(owners);
	}

	public Enumerator[] getOwnersWithCstr() {
		return getEnumerator(ownersc);
	}

	public Enumerator[] getTypes() {
		return getEnumerator(types);
	}

	static double getPerc(double val, double max) {
		double ret = val * 100 / max;
		return Math.round(ret * 10) / 10.0;
	}

	public double getSoldPerc() {
		return getPerc(lotsSold, lotsTotal);
	}

	public double getCstrPerLotPerc() {
		return getPerc(cstrTotal, lotsTotal);
	}

	public double getCstrPerOwnerPerc() {
		return getPerc(cstrTotal, lotsSold);
	}
}
