/* Obligatorisk innlevering 02
 * ----------------------------
 * Utlevert 2009/09/22 ??:??:??
 * Påbegynt 2009/09/22 09:02:38
 * Fullført 2009/09/27 01:22:17
 * ----------------------------
 * Utført av Alexander Edland
 * Publisert på www.u3m.net
 */
package oblig02;

public class Main {

	static IO io;
	static LotMan mlot;
	static Helper h;

	public static void main(String[] args) {
		io = new IO();															// I/O.

		if (io.getb("Load last database", true)) {
			mlot = new LotMan(13, 11, "oblig02.db");							// Load previous database
		} else {
			mlot = new LotMan(13, 11);											// Create new lot collection
		}
		h = new Helper(mlot, io);												// Why clutter stuff up?
		io.put();

		boolean GTFO = false;													// Have we quit loopan yet?
		while (!GTFO) {															// If not, LETS GO LOL
			io.put(io.colour(4) + "-=+> KINGSHILL LOTSALE <+=-");				// ^_^
			io.put(io.colour(-1));
			io.put("You may pick amongst the following.");
			io.put();
			io.put("  1) Buy lot");
			io.put("  2) List data");
			io.put("  3) Draw map");
			io.put("  4) New house");
			io.put("  5) Statistics");
			io.put("  6) Quit");
			io.put();
			int opt = io.get("Choose wisely", 1, 6);							// Ask for int between 1 and 6

			if (opt == 1) buyLot(new int[0], true);								// buy lot
			if (opt == 2) listData();											// list data
			if (opt == 3) {
				io.put(mlot.drawMap(io, true));									// draw map
				io.get();
				io.put(mlot.drawMap(io, false));
			}
			if (opt == 4) newHouse(new int[0]);									// new house
			if (opt == 5) getStats();											// MOTHERFUCKING STATISTICS
			if (opt == 6) {
				if (mlot.Save("oblig02.db") ||
					io.getb("Unable to save! Continue anyhow", false)) {		// Able to save or ok anyhow?
					GTFO = true;												// GTFO.
				}
			}
			io.put();															// Newline does it
		}
	}

	static void buyLot(int[] ptr, boolean queryBuyNext) {
		if (ptr.length == 0) {													// Was a specific lot passed?
			ptr = h.requestLot();												// Nope. Ask user.
		}
		int x = ptr[0];															// Why make it difficult...
		int y = ptr[1];															// When you can make it simple?
		boolean hasOwner = !mlot.isAvailable(x, y);								// Check if lot has an owner
		String owner = h.requestName(true);										// Ask for owner
		if (hasOwner && owner.equalsIgnoreCase(mlot.getOwner(x, y))) {			// Owner matches current one
			io.throwError("“" + mlot.getOwner(x, y) + "” is " +
				"already enlisted as the owner of this lot!");					// This is madness!
			return;																// Escape from madness
		}
		if (hasOwner) {															// Ownership transferran gaems
			if (!io.getb("This lot's the property of “" + mlot.getOwner(x, y) +
				"”. Are you sure you wish to change owner", true)) {			// Are we completely sure?
				return;															// Guess not.
			}
		}
		if (!mlot.hasOwnerLike(owner)) {										// This owner is new on the block
			if (!io.getb("New owner... Continue", true)) {						// Ask if we should continue
				return;															// Mayhaps not.
			}
		}
		mlot.setOwner(x, y, owner);												// Then flesking we unto.
		io.put("Company “" + owner + "” is now the proud " +
			"owner of lot " + x + "-" + y + " :D");								// This was a triumph.
		if (queryBuyNext) {														// Ask to buy next lot also?
			ptr = h.checkBuyNext(x, y);											// Yep. Ask the user.
			if (ptr.length > 0) {												// Affirmative?
				buyLot(ptr, true);												// Affirmative.
			}
		}
	}

	static void listData() {
		int[] bounds = mlot.getBounds();										// Figure out the size of our field
		int bx = bounds[0];														// This is the width...
		int by = bounds[1];														// And this is the height.
		int totalLots = 0;														// To hold total lot count
		int totalBought = 0;													// To hold buy count
		int totalConstructions = 0;												// Also constructions

		for (int y = 0; y < by; y++) {											// Iterate rows
			for (int x = 0; x < bx; x++) {										// Iterate columns
				totalLots++;													// Increase total lot count
				if (!mlot.isAvailable(x, y)) {									// Has this been bought?
					totalBought++;												// Yes, yes it has
					String type = mlot.getType(x, y);							// Read construction type
					String owner = mlot.getOwner(x, y);							// Read comapny name
					io.puts("Lot " + x + "-" + y + " is the " +
						"property of “" + owner + "”. ");						// Print owner stats
					if (type.length() > 0) {
						totalConstructions++;									// Increase constr. count
						io.put("There's a " + type + " located here.");			// Print constr. info
					} else {
						io.put("There are no constructions on this lot.");		// No construction here :(
					}
				}
			}
		}
		System.out.println("In total, there are " + totalLots +
			" lots of which " + totalBought + " have been bought. " +
			"Also, there are " + totalConstructions + " constructions.");		// Le grande finale.
	}

	static void newHouse(int[] ptr) {
		if (ptr.length==0) {
			ptr = h.requestLot();												// Ask for lot position
		}
		int x = ptr[0];															// This be our horz position
		int y = ptr[1];															// Hey guess what this is
		if (mlot.isAvailable(x, y)) {											// Sold yet?
			if (io.getb("This lot hasn't been bought yet. Buy now", true)) {	// No.
				buyLot(ptr, false);												// Let's sell it right away!
				io.put();														// Cosmetical bullshit
			} else {
				return;															// No buyer, bail out bail out
			}
		} else {
			io.put("FYI, the owner of this lot is “" +
				mlot.getOwner(x, y) + "”.");									// Basic owner infoes
		}
		String type = h.requestName(false);										// Ask user for cstr type
		mlot.setType(x, y, type);												// Apply type to lotmanager
		io.put("DUE TO SOME UNEXPLAINABLE FANTASTIC SCIENCE, " +
			"THIS LOT NOW HAS A " + type + ".");								// FUDGE YES.
		ptr = h.checkBuyNext(x, y);												// Buy next house also?
		if (ptr.length > 0) {													// Affirmative?
			newHouse(ptr);														// Affirmative.
		}
	}

	static void getStats() {
		StatsBuilder stats = new StatsBuilder(mlot);							// Let's gather what we know.

		Enumerator[] constr = stats.getTypes();									// Read values from statsbuilder
		io.put("All housetypes (" + constr.length +
			"), sorted by popularity:");
		h.dumpEnumerator(constr);												// Display the values

		Enumerator[] company = stats.getOwners();
		io.put("All companies (" + company.length +
			"), sorted by lot count:");
		h.dumpEnumerator(company);

		Enumerator[] companyc = stats.getOwnersWithCstr();
		io.put("All companies (" + companyc.length +
			"), sorted by house count:");
		h.dumpEnumerator(companyc);

		io.put("In total, there are " + stats.getLotsTotal() +
			" lots on our premises.");

		io.put("Out of these, " + stats.getLotsSold() +
			" have been sold. That's " + stats.getSoldPerc() + "%.");

		io.put("Out of these, " + stats.getCstrTotal() + " have " +
			"constructions. That's " + stats.getCstrPerOwnerPerc() + "%.");

		io.put("In total, " + stats.getCstrPerLotPerc() +
			"% of all lots have a construction of sorts.");
	}
}
