package oblig02;

import java.util.ArrayList;
public class LotMan {

	Lot[][] lot;																// Our lot collection

	public LotMan(int x, int y) {
		lot = new Lot[y][x];													// Create a new YxX array
	}

	public LotMan(int x, int y, String filename) {
		this(x, y);																// Fallback in case load fails
		try {
			java.io.FileReader fr = new java.io.FileReader(filename);			// Reads file to bytearrays
			java.io.BufferedReader br = new java.io.BufferedReader(fr);			// Converts ^ to strings
			int[] sz = parsePtr(br.readLine());									// First line is array size
			lot = new Lot[sz[1]][sz[0]];										// Instantiate the array
			while (true) {														// Continue until exception
				int[] ptr = parsePtr(br.readLine());							// Read index
				setOwner(ptr[0], ptr[1], br.readLine());						// Read and set company
				setType(ptr[0], ptr[1], br.readLine());							// Read and set cstr-type
			}
		} catch (Exception ex) {
		}
	}

	public int[] getBounds() {
		return new int[]{lot[0].length, lot.length};
	}

	public boolean Save(String filename) {
		try {
			java.io.FileWriter fw = new java.io.FileWriter(filename);
			java.io.BufferedWriter bw = new java.io.BufferedWriter(fw);
			int[] sz = getBounds();
			bw.write(sz[0] + "." + sz[1] + "\n");
			for (int y = 0; y < sz[1]; y++) {
				for (int x = 0; x < sz[0]; x++) {
					if (!isAvailable(x, y)) {
						bw.write(x + "." + y + "\n");
						bw.write(getOwner(x, y) + "\n");
						bw.write(getType(x, y) + "\n");
					}
				}
			}
			bw.flush();
			fw.flush();
			fw.close();
			return true;
		} catch (Exception ex) {
			return false;
		}
	}

	public Lot[][] getLots() {
		return lot;
	}

	static int[] parsePtr(String ptrs) {
		int ofs = -1;															// No offset identified yet
		for (int a = 0; a < ptrs.length(); a++) {								// Iterate characters in ptrs
			char ch = ptrs.charAt(a);											// Get character on this position
			if (ch < '0' || ch > '9') {											// Is it a number?
				ofs = a;														// No. This is the offset.
			}
		}
		try {
			return new int[]{
					Integer.parseInt(ptrs.substring(0, ofs)),
					Integer.parseInt(ptrs.substring(ofs + 1))};					// ARRAY FOR PRESIDENT.
		} catch (Exception ex) {
			return new int[0];
		}
	}

	boolean validPtr(int x, int y) {
		return (y < lot.length &&
			x < lot[0].length);
	}

	boolean isAvailable(int x, int y) {
		if (validPtr(x, y)) {													// Verify that this is within bounds
			return lot[y][x] == null;											// Return true if not defined (vacant)
		}
		return false;
	}

	boolean setOwner(int x, int y, String owner) {
		if (validPtr(x, y)) {
			lot[y][x] = new Lot(owner);
			return true;
		} else {
			return false;
		}
	}

	boolean setType(int x, int y, String type) {
		if (!isAvailable(x, y)) {
			lot[y][x].type = type;
			return true;
		} else {
			return false;
		}
	}

	String drawMap(IO io, boolean companies) {
		StatsBuilder stats = new StatsBuilder(this);							// Shit just got real yo
		Enumerator[] legend = null;
		if (companies) {
			legend = stats.getOwners();											// Base the map on companies
		} else {
			legend = stats.getTypes();											// Base the map on buildings
		}
		StringBuilder ret = new StringBuilder();								// Bad performance? Not on my shift.
		ret.append("   ");														// Initial padding for column header
		int[] bounds = getBounds();												// Size of the lots array
		for (int a = 0; a < bounds[0]; a++) {									// Iterate columns
			ret.append(String.format("%3d", a));								// Print this column no., spanning 3 chars
		}
		ret.append("\n");														// Need a newline here!
		for (int y = 0; y < bounds[1]; y++) {									// Iterate rows
			ret.append(String.format("%3d", y));								// Print this row no.
			for (int x = 0; x < bounds[0]; x++) {								// Iterate columns
				char append = '.';												// Default to "Empty lot"
				if (!isAvailable(x, y)) {										// ...or is it?
					for (int a = 0; a < legend.length; a++) {					// Let's find the legend.
						if (companies) {										// We are in company modo
							if (legend[a].matches(lot[y][x].owner)) {			// Is this our company?
								append = (char)('a'+a);							// Yes. Print company legend.
							}
						}else{													// Construction modo it is!
							if (legend[a].matches(lot[y][x].type)) {			// This be our construction?
								append = (char)('a'+a);							// Yes, yes it is. Legend etc.
							}
						}
					}
					if (lot[y][x].type.length() > 0) {							// Does this lot have a house?
						append -= 'a'-'A';										// In that case, capslock tiem.
					}
				}
				//ret.append(String.format("%3s",
				//	lot[y][x] == null ? "." : "X"));							// x if occupied, . if not
				if (append == '.') {
					ret.append(io.colour(5));
				}else if (append >= 'a' && append <= 'z') {
					ret.append(io.colour(1));
				}else if(append >= 'A' && append <= 'Z') {
					ret.append(io.colour(2));
				}
				ret.append(String.format("%3s", append));
			}
			ret.append(io.colour(-1) + "\n");									// Erecting a newline!
		}
		for (int a = 0; a < legend.length; a++) {
			ret.append("  " + (char)('a'+a) + ") " + legend[a].name + "\n");
		}
		return ret.toString();													// Nothing to see here, move along now
	}

	int[][] getBy(String owner, String type) {
		int[] bounds = getBounds();												// Size of the lots array     //TODO
		ArrayList<int[]> ret = new ArrayList<int[]>();							// Dynamically sized array
		for (int y = 0; y < lot.length; y++) {									// Iterate rows
			for (int x = 0; x < lot[y].length; x++) {							// Iterate columns
				if (lot[y][x] != null) {
					if (owner.length() == 0) {									// Find by TYPE
						if (type.equalsIgnoreCase(lot[y][x].type)) {			// Type matches?
							ret.add(new int[]{x, y});							// Yes, yes it does.
						}
					} else {													// Find by OWNERID
						if (owner.equalsIgnoreCase(lot[y][x].owner)) {			// OwnerID matches?
							ret.add(new int[]{x, y});							// Very much so.
						}
					}
				}
			}
		}
		int[][] retf = new int[ret.size()][];
		for (int a = 0; a < retf.length; a++) {
			retf[a] = ret.get(a);
		}
		return retf;
	}

	int[][] getByType(String type) {
		return getBy("", type);
	}

	int[][] getByOwner(String owner) {
		return getBy(owner, "");
	}

	String getOwner(int x, int y) {
		if (validPtr(x, y) &&
			!isAvailable(x, y)) {
			return lot[y][x].owner;
		} else {
			return "";
		}
	}

	String getType(int x, int y) {
		if (validPtr(x, y) &&
			!isAvailable(x, y)) {
			return lot[y][x].type;
		} else {
			return "";
		}
	}

	boolean hasOwnerLike(String owner) {
		int[] bounds = getBounds();												// Size of the lots array
		for (int y = 0; y < bounds[1]; y++) {
			for (int x = 0; x < bounds[0]; x++) {
				if (!isAvailable(x, y) &&
					lot[y][x].owner.equalsIgnoreCase(owner)) {
					return true;
				}
			}
		}
		return false;
	}

	boolean hasTypeLike(String type) {
		int[] bounds = getBounds();												// Size of the lots array
		for (int y = 0; y < bounds[1]; y++) {
			for (int x = 0; x < bounds[0]; x++) {
				if (!isAvailable(x, y) &&
					lot[y][x].type.equalsIgnoreCase(type)) {
					return true;
				}
			}
		}
		return false;
	}
}
