package oblig02;

public class Helper {

	IO io;
	LotMan mlot;

	public Helper(LotMan mlot, IO io) {
		this.io = io;
		this.mlot = mlot;
	}

	int[] checkBuyNext(int x, int y) {
		x++;																	// Try increasing X by 1
		int[] bounds = mlot.getBounds();										// Get lot bounds to verify
		if (x >= bounds[0]) {													// X above limit?
			y++;																// Increase Y,
			x = 0;																// Reset X...
			if (y >= bounds[1]) {												// Is Y out of bounds?
				return new int[0];												// Out of lots.
			}
		}
		if (io.getb("Buy next item also", true)) {								// Time to ask the user.
			io.put();															// Cosmetics.
			return new int[]{x, y};												// Return next lot
		}
		return new int[0];														// User declined offer
	}

	static String catEnumerator(Enumerator[] enumr) {
		StringBuilder ret = new StringBuilder();
		for (int a = 0; a < enumr.length; a++) {								// Iterate enumerators
			ret.append("  " + enumr[a].count + "x " + enumr[a].name + "\n");	// Print count and value
		}
		return ret.toString();
	}
	
	void dumpEnumerator(Enumerator[] enumr) {
		io.put(catEnumerator(enumr));
	}

	int[] requestLot() {
		int[] ptr = new int[0];													// X,Y location of lot
		while (ptr.length == 0) {												// Until we have valid ptr
			String ptrs = io.gets("Input lot location");						// Ask for lot ID
			ptr = LotMan.parsePtr(ptrs);										// Parse the lot ID
			if (ptr.length == 0 ||
				!mlot.validPtr(ptr[0], ptr[1])) {								// Didn't parse or out of bounds?
				io.throwError("Illegal lot location.");							// Yeah.
				ptr = new int[0];												// Stay in the loop for now
			}
		}
		return ptr;																// All good to go
	}

	String requestName(boolean owner) {
		String subject = owner ? "owner" : "construction";						// Correct grammar is important.
		boolean existingValues = false;											// Existing items of this kind?
		StatsBuilder stats = new StatsBuilder(mlot);							// Let's gather what we know.
		Enumerator[] valueList = null;											// Our list of existing items
		if (owner) {															// Owner?
			valueList = stats.getOwners();										// Owner.
		} else {																// Cstr?
			valueList = stats.getTypes();										// Cstr.
		}
		existingValues = valueList.length > 0;									// And there you have it.
		if (existingValues) {													// Did we get any hits?
			io.put("Existing " + subject + "s:");
			for (int a = 0; a < valueList.length; a++) {						// Iterate items
				String ident = ((char) (a + 'a')) + ") ";						// This item identifier
				io.put("  " + ident + valueList[a].name);						// Display with identifier
			}
		}
		String tmp = "";														// Identifier goes here
		String type = null;														// Full name goes here
		while (type == null) {													// While no accepted entry
			if (existingValues) {												// Are there existing types?
				tmp = io.gets("Identifier or " + subject + " name");			// Prompt for identifier
			} else {
				tmp = io.gets("Enter " + subject + " name");					// GRAMMAR!!
			}
			if (tmp.length() == 1) {											// Did user enter an ident?
				int typei = tmp.toLowerCase().charAt(0) - 'a';					// Yeah. Get array offset.
				if (typei >= 0 && typei < valueList.length) {					// Offset out of bounds?
					type = valueList[typei].name;								// No. Set full name by id.
				}
			} else if (tmp.length() > 1) {										// Or maybe a name...
				type = tmp;														// Yep, a name.
			}
			if (type == null) {													// Wait.
				io.throwError("Oh god how did this happen " +
					"I am not good with semantics");							// What?
			}
		}
		return type;
	}

	static void flipArray(Object[] array) {
		int l, r;
		for (l = 0, r = array.length - 1;
			l < r; l++, r--) {
			Object tmp = array[r];
			array[r] = array[l];
			array[l] = tmp;
		}
	}
}
