/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

package eplist;

class S {
	// TLNote: es means `eightState'
	public static void print(int[] es, int dir, int delta, boolean revert) {
		int from = es[0] - 1;
		from +=
			dir == MOVE_UP ? -3 : //
			dir == MOVE_DOWN ? 3 : //
			dir == MOVE_LEFT ? -1 : //
			dir == MOVE_RIGHT ? 1 : 0;

		char[][] buf = {
			"+---+---+---+".toCharArray(),
			"|   |   |   |".toCharArray(),
			"+---+---+---+".toCharArray(),
			"|   |   |   |".toCharArray(),
			"+---+---+---+".toCharArray(),
			"|   |   |   |".toCharArray(),
			"+---+---+---+".toCharArray()};

		for (int y = 0; y < 3; y++) {
			for (int x = 0; x < 3; x++) {
				int indice = (y * 3) + x;
				int sbx = 4 * x + 2;
				int sby = y * 2 + 1;
				int deltaX = 0, deltaY = 0;
				if (indice == from) {
					deltaY =
						dir == MOVE_UP ? delta * 1 : //
						dir == MOVE_DOWN ? -delta * 1 : 0;
					deltaX =
						dir == MOVE_LEFT ? delta * 2 : //
						dir == MOVE_RIGHT ? -delta * 2 : 0;
				}
				if (es[indice + 1] != 0) {
					buf[sby + deltaY][sbx + deltaX] = //
						(char)('0' + es[indice + 1]);
				}
			}
		}
		StringBuilder sb = new StringBuilder();
		sb.append("\n ");
		for (char[] y: buf) {
			for (char x: y) {
				sb.append(x);
			}
			sb.append(" \n ");
		}
		if (revert) System.out.println(cursorUp(1+9));
		System.out.println(sb.toString());
	}

	public static void oldPrint(int[] es, boolean revert) {
		System.out.println((char)27 + "[H" +
			" +---+---+---+\n" +
			" | " + (es[1] == 0 ? " " : es[1]) +
			" | " + (es[2] == 0 ? " " : es[2]) +
			" | " + (es[3] == 0 ? " " : es[3]) + " |\n" +
			" +---+---+---+\n" +
			" | " + (es[4] == 0 ? " " : es[4]) +
			" | " + (es[5] == 0 ? " " : es[5]) +
			" | " + (es[6] == 0 ? " " : es[6]) + " |\n" +
			" +---+---+---+\n" +
			" | " + (es[7] == 0 ? " " : es[7]) +
			" | " + (es[8] == 0 ? " " : es[8]) +
			" | " + (es[9] == 0 ? " " : es[9]) + " |\n" +
			" +---+---+---+\n");
	}
	public static final int MOVE_UP = 0;
	public static final int MOVE_DOWN = 1;
	public static final int MOVE_LEFT = 2;
	public static final int MOVE_RIGHT = 3;

	public static boolean move(int[] es, int dir) {
		return (dir == MOVE_UP && shove(es, -3)) ||
			(dir == MOVE_DOWN && shove(es, +3)) ||
			(dir == MOVE_LEFT && shove(es, -1)) ||
			(dir == MOVE_RIGHT && shove(es, +1));
	}

	private static boolean shove(int[] es, int stp) {
		int nil = es[0];
		if (stp == 1 && (nil == 3 || nil == 6))
			return false;
		if (stp == -1 && (nil == 4 || nil == 7))
			return false;
		stp += nil;
		if (stp < 1 || stp >= es.length)
			return false;
		es[nil] = es[stp];
		es[stp] = 0;
		es[0] = stp;
		return true;
	}
	private static final int[] done = {9, 1, 2, 3, 4, 5, 6, 7, 8, 0};

	public static boolean areWeDoneYet(int[] es) {
		for (int a = 0; a < es.length; a++) {
			if (done[a] != es[a])
				return false;
		}
		return true;
	}

	public static int[] clone(int[] es) {
		int[] ret = new int[es.length];
		for (int a = 0; a < ret.length; a++) {
			ret[a] = es[a];
		}
		return ret;
	}

	public static String cursorUp(int count) {
		//StringBuilder ret = new StringBuilder();
		//for (int a = 0; a < count; a++) {
		//	ret.append((char)27 + "[A");
		//}
		//return ret.toString();
		return (char)27 + "[" + count + "A";
	}
}
