/*
 *  Copyright (C) 2010  ed <tripflag@gmail.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License v2
 *  (version 2) as published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, refer to the following URL:
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package eplist;

import java.util.ArrayList;

public class Main {
	public static void main(String[] args) {
		new Main().run();
	}

	void run() {
		int[] status = {9, 1, 2, 3, 4, 5, 6, 7, 8, 0};
		for (int a = 0; a < 9001; a++) {
			S.move(status, (int) (Math.random() * 4));
		}
		//status = new int[]{5, 5, 2, 6, 7, 0, 3, 4, 8, 1};
		S.print(status, -1, 0, false);
		//Gooey gooey = new Gooey(status);
		//System.exit(0);
		System.out.println("After OVER 9000 shuffles;");
		System.out.println("This is our final destiny.");
		System.out.println("LET THE SOLVING BEGIN.");
		key();
		String soln = solve(status);
		System.out.println(S.cursorUp(1 + 1));
		System.out.println("Found solution: " + soln);
		key();
		System.out.println(S.cursorUp(1 + 1));
		S.print(status, -1, 0, false);

		soln = soln.split("\\.")[1];
		for (int a = 0; a < soln.length(); a++) {
			char c = soln.charAt(a);
			int dir =
					c == 'u' ? 0 : //
					c == 'd' ? 1 : //
					c == 'l' ? 2 : //
					c == 'r' ? 3 : -1;
			for (int delta = 1; delta < 3; delta++) {
				S.print(status, dir, delta, true);
				slp(100);
			}
			slp(100);
			S.move(status, dir);
			//printarray(status);
		}
	}

	private void test() {
		int[] status = {9, 1, 2, 3, 4, 5, 6, 7, 8, 0};
		while (true) {
			char in = key();
			if (in == 'w')
				S.move(status, S.MOVE_UP);
			if (in == 's')
				S.move(status, S.MOVE_DOWN);
			if (in == 'a')
				S.move(status, S.MOVE_LEFT);
			if (in == 'd')
				S.move(status, S.MOVE_RIGHT);
			S.print(status, -1, 0, true);
			if (S.areWeDoneYet(status)) {
				System.out.println("FUCK YES.");
				break;
			}
		}
	}

	private String solve(int[] status) {
		//HashMap<int[], Integer> old = new HashMap<int[], Integer>();
		BT old = new BT();
		ArrayList<EightEvent> queue = new ArrayList<EightEvent>();
		queue.add(new EightEvent(status, ""));
		boolean done = false;
		int cnt = 0;
		while (queue.size() > 0) {
			cnt++;
			EightEvent tmp = queue.remove(0);
			if (cnt % 10000 == 0) {
				System.out.println(S.cursorUp(1 + 1));
				System.out.println(" -!- " + queue.size() + //
						"@" + cnt + " -!- " + tmp.history.toString());
			}
			for (int a = 0; a < 4; a++) {
				EightEvent next = tmp.branch(a);
				if (next != null
						&& old.add(next.state)) {
					if (S.areWeDoneYet(next.state)) {
						return cnt + "." + next.history.toString();
					} else {
						queue.add(next);
					}
				}
			}
		}
		return "";
	}

	private void read(StringBuilder ret) {
		char in = key();
		if (in == ' ')
			return;
		else {
			if (in != 0x0d
			 && in != 0x0a) {
				ret.append(in);
			}
			read(ret);
		}
	}

	private void slp(int n) {
		try {
			Thread.sleep(n);
		} catch (Exception ex) {
		}
	}

	private char key() {
		try {
			while (System.in.available() > 0)
				System.in.read();
			return (char) System.in.read();
		} catch (Exception ex) {
			return '\0';
		}
	}
}
