/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
package eplist;

class EightEvent {
	int[] state;
	StringBuilder history;
	final char[] dirmap = {'u', 'd', 'l', 'r'};

	public EightEvent(int[] state, String history) {
		this.history = new StringBuilder(history);
		this.state = state;
	}

	public EightEvent branch(int dir) {
		int[] tmp = S.clone(state);
		if (S.move(tmp, dir)) {
			return new EightEvent(tmp, history//
					.toString() + dirmap[dir]);
		} else {
			return null;
		}
	}
}
