/*
 * Copyright (C) 2010  ed <tripflag@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following URL:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

package eplist;

class BTN {
	int[] state;
	BTN left, right;
	public BTN(int[] state) {
		this.state = state;
		right = null;
		left = null;
	}
	public int[] getValue() {
		return state;
	}
	public int compareTo(BTN btn) {
		int[] otherState = btn.getValue();
		if (state.length != otherState.length) {
			return -9001;
		}else{
			for (int a = 0; a < state.length; a++) {
				if (state[a] != otherState[a]) {
					/*
					 * int ret = state[a] - otherState[a];
					 * return ret + ((ret/Math.abs(ret)) *
					 *     ((state.length-1)-a) *
					 *     state.length);
					 */
					// Forenkling, bare gyldig in bintrær
					return state[a] - otherState[a];
				}
			}
		}
		return 0;
	}
}
