﻿/*
 * Slidan - An eightpuzzle solver and visualizer in C#
 * Copyright (C) 2010  ed (tripflag@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following url:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
using System;
using System.Collections.Generic;
using System.Text;
namespace Slidan {

    /// <summary>
    /// Methods to execute actions on a tilestate (SEvent).
    /// You will need OVER 9000 TERABYTE RAM if you want
    /// this part object oriented.
    /// </summary>
    class SUtils {
        // Legal move directions
        public const int MOVE_UP = 0;
        public const int MOVE_DOWN = 1;
        public const int MOVE_LEFT = 2;
        public const int MOVE_RIGHT = 3;

        // Check whether `dir' is either of the legal directions.
        // If it is, try to move in this direction.
        // Return true when both assumptions are correct for either allowed direction.
        public static bool move(int[] es, int dir) {
            return (dir == MOVE_UP && shove(es, -3)) ||
                (dir == MOVE_DOWN && shove(es, +3)) ||
                (dir == MOVE_LEFT && shove(es, -1)) ||
                (dir == MOVE_RIGHT && shove(es, +1));
        }

        // Move a tile on current EightState `stp' steps
        private static bool shove(int[] es, int stp) {
            int nil = es[0];                                            //position of blank tile
            if (stp == 1 && (nil == 3 || nil == 6)) return false;       //horizontally out of bounds, right column
            if (stp == -1 && (nil == 4 || nil == 7)) return false;      //horizontally out of bounds, left column
            stp += nil;                                                 //horizontally ok, add stepsize to location of nil tile
            if (stp < 1 || stp >= es.Length) return false;              //vertically out of bounds
            
            // Swap blank and indicated tile
            es[nil] = es[stp];
            es[stp] = 0;
            es[0] = stp;
            return true;
        }

        // C# doesn't allow constant (final) arrays.
        // Mentally superimpose the word `constant' in sentence below.
        private static int[] done = new int[]{ 9, 1, 2, 3, 4, 5, 6, 7, 8, 0 };

        // Check whether EightState is in the `done' state
        public static bool areWeDoneYet(int[] es) {
            for (int a = 0; a < es.Length; a++) {
                if (done[a] != es[a]) return false;
            }
            return true;
        }

        // Create deep copy of an EightState
        public static int[] clone(int[] es) {
            int[] ret = new int[es.Length];
            for (int a = 0; a < ret.Length; a++) {
                ret[a] = es[a];
            }
            return ret;
        }
    }
}