﻿/*
 * Slidan - An eightpuzzle solver and visualizer in C#
 * Copyright (C) 2010  ed (tripflag@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following url:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
using System;
using System.Collections.Generic;
using System.Text;
namespace Slidan {

    /// <summary>
    /// The object-oriented part of the code (lol)
    /// Everything would be horribly bloated and a
    /// massive RAM sink if I OO'd the methods.
    /// </summary>
    class SEvent {
        public int[] state; //Current board state 
        public StringBuilder history; //Moves leading up to this state
        public static char[] dirmap = new char[] { 'u', 'd', 'l', 'r' };

        public SEvent(int[] state, String history) {
            this.history = new StringBuilder(history);
            this.state = state;
        }

        public SEvent fork(int dir) {

            // Execute move and return new instance
            int[] tmp = SUtils.clone(state);
            if (SUtils.move(tmp, dir)) {

                // Move successful, create instance
                return new SEvent(tmp, history//
                    .ToString() + dirmap[dir]);

            } else {
                // Illegal move, fuck this
                return null;
            }
        }
    }
}