﻿/*
 * Slidan - An eightpuzzle solver and visualizer in C#
 * Copyright (C) 2010  ed (tripflag@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * (version 2) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, refer to the following url:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Slidan {
    public partial class Form1 : Form {
        public Form1() {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e) {
            // Disregard this form, we'll never actually show it.

            int shuffles = 9001;
            Random random = new Random();

            if (!Program.silent) MessageBox.Show(
                "Shuffling " + shuffles + " times, then searching for solution.");

            string ret = "sup";
            int[] status = { };
            while (ret.Length < 10) {
                // We don't want a short solution, as that wouldn't
                // be as SUGOI when presenting the app to anyone.
                status = new int[] { 9, 1, 2, 3, 4, 5, 6, 7, 8, 0 };
                for (int a = 0; a < shuffles; a++) {
                    // Shuffle the board
                    SUtils.move(status, random.Next(0, 4));
                }
                // Solve this board
                ret = run(status);
            }
            MessageBox.Show("Found solution: " + ret.ToUpper() + "\r\n\r\n" +
                "Press `F1' for help");

            // Trim away the nulltile position at the start...
            Array.Reverse(status);
            Array.Resize(ref status, status.Length - 1);
            Array.Reverse(status);

            // Show GUI with this board
            new SDialogue(status).run(ret);

            // KILL IT WITH FIRE
            System.Diagnostics.Process.GetCurrentProcess().Kill();

        }

        string run(int[] status) {

            // Binary Tree (to check whether a state has occured earlier)
            BT old = new BT();

            // The queue of EightStates (SEvent instances) to check/fork
            List<SEvent> queue = new List<SEvent>();

            // Add initial board (state)
            queue.Add(new SEvent(status, ""));
            bool done = false;                                      // not done yet
            while (!done) {
                SEvent tmp = queue[0];                              // read next state to check
                queue.RemoveAt(0);                                  // remove said state
                for (int a = 0; a < 4; a++) {                       // For each (of the 4) directions...
                    SEvent next = tmp.fork(a);                      // Create fork in this direction
                    if (next != null &&                             // Was this move legal?
                        old.add(next.state)) {                      // Have this state occured before?
                        if (SUtils.areWeDoneYet(next.state)) {      // Check whether we have our solution
                            return next.history.ToString();         // Yes, return it.
                        } else {
                            queue.Add(next);                        // No, add for further forkan.
                        }
                    }
                }
            }
            return "";                                              // HOLY SHIT NO SOLUTION
        }
    }
}