package aardwark;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeChip {

	private SimpleDateFormat sdf;
	private int limLumi, limTemp;
	private int alarmBase;
	private long alarmUT;

	public TimeChip()
	{
		limLumi = 75;
		limTemp = 17;
		alarmBase = 700; //lol
		sdf = new SimpleDateFormat("HHmmss");
	}

	public String getTime()
	{
		return sdf.format(System.currentTimeMillis());
	}

	public String getAlarm()
	{
		if (alarmUT > 0)
		{
			return sdf.format(alarmUT);
		}
		else
		{
			//return "888888";
			//return sdf.format(alarmBase);
			int m = alarmBase % 100;
			int h = alarmBase / 100; //!
			return String.format("%02d%02d", h, m);
		}
	}

	public boolean enabled()
	{
		return alarmUT > 0;
	}

	public void setAlarm(String time)
	{
		alarmUT = 0;
		int h = Integer.parseInt(time.substring(0, 2));
		int m = Integer.parseInt(time.substring(2, 4));
		alarmBase = h * 100 + m; //wolololo
		//setAlarm(true);
	}

	public void setAlarm(int distance)
	{
		Calendar now = Calendar.getInstance();
		now.add(Calendar.SECOND, distance);
		alarmUT = now.getTimeInMillis();
	}

	public void setAlarm(boolean enabled)
	{
		if (!enabled)
		{
			alarmUT = 0;
		}
		else
		{
			int m = alarmBase % 100;
			int h = alarmBase / 100;
			Calendar now = Calendar.getInstance();
			Calendar zilch = Calendar.getInstance();
			// Base our calculations on current time,
			// as well as this day at midnight:
			
			zilch.set( //REALLY, ZUN?
				now.get(Calendar.YEAR),
				now.get(Calendar.MONTH),
				now.get(Calendar.DATE),
				h, m, 0); //HURR DURR

			if (zilch.before(now))
			{
				zilch.add(Calendar.HOUR_OF_DAY, 24);
			}
			alarmUT = zilch.getTimeInMillis();
			
			// if I've understood the «Calendar» class correctly,
			// this implementation /should/ be fully DST safe. Yeah.
			//
			// let's be realistic and assume I haven't, seeing how
			// java is ass backwards and imposssible to comprehend.
			//
			// oh by the way, anyone remember the «Date» class?
			// it's probably not even my fault if this fails...
			//
			// ----------------------------------
			// | DO NOT TRUST DURING DST CHANGE |
			// ----------------------------------
			//                I miss C# already.
		}
	}

	public int limLumi()
	{
		return limLumi;
	}
	public void limLumi(int i)
	{
		limLumi = i;
	}
	public int limTemp()
	{
		return limTemp;
	}
	public void limTemp(int i)
	{
		limTemp = i;
	}

	public boolean soundAlarm()
	{
		return (alarmUT > 0 &&
			alarmUT <= System.currentTimeMillis());
	}
}
