/*
 * This is mostly code from the example jorbis player
 * Slight rewriting by yours truly to fit this purpose
 */
package aardwark;

import java.io.InputStream;
import com.jcraft.jogg.*;
import com.jcraft.jorbis.*;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class OggCodec extends Thread
{
	private boolean gtfo;
	private InputStream inputStream = null;
	private byte[] buffer = null;
	private int bSize = 2048;
	private int bCount = 0;
	private int bIndex = 0;
	private byte[] cbuffer = null;  // converted buffer (handles multichannel)
	private int cbSize;             // converted buffer size
	private SourceDataLine outputLine = null;
	private float[][][] pcmData;
	private int[] pcmIndex;
	//
	//derp
	private long started = -1;
	//
	// Here are the four required JOgg objects...
	private Packet joggPacket = new Packet();
	private Page joggPage = new Page();
	private StreamState joggStreamState = new StreamState();
	private SyncState joggSyncState = new SyncState();
	//
	// ... followed by the four required JOrbis objects.
	private DspState jorbisDspState = new DspState();
	private Block jorbisBlock = new Block(jorbisDspState);
	private Comment jorbisComment = new Comment();
	private Info jorbisInfo = new Info();

	public OggCodec(String filename)
	{
		try
		{
			inputStream = new java.io.FileInputStream(filename);
		}
		catch (Exception ex)
		{
			err("File not found");
		}
		start();
	}

	public void stopit()
	{
		gtfo = true;
	}

	private void err(String msg)
	{
		System.err.println(msg);
	}

	@Override
	public void run()
	{
		if (inputStream == null)
		{
			err("No opened stream = nothing to do");
			return;
		}
		initializeJOrbis();
		if (readHeader())
		{
			if (initializeSound())
			{
				readBody();
			}
		}
		gtfo = true;
		cleanUp();
	}

	public boolean isPlaying()
	{
		return !gtfo;
	}

	private void initializeJOrbis()
	{
		joggSyncState.init();
		joggSyncState.buffer(bSize);
		buffer = joggSyncState.data;
	}

	private boolean readHeader()
	{
		boolean needMoreData = true;
		int packet = 1;
		while (needMoreData)
		{
			try
			{
				bCount = inputStream.read(buffer, bIndex, bSize);
			}
			catch (Exception ex)
			{
				err("File reading failed");
			}
			joggSyncState.wrote(bCount);
			switch (packet)
			{
				case 1:
				{
					switch (joggSyncState.pageout(joggPage))
					{
						case -1:
						{
							err("Corrupt data (1)");
							return false;
						}
						case 0:
						{
							break; //need more
						}
						case 1:
						{
							joggStreamState.init(joggPage.serialno());
							joggStreamState.reset();
							jorbisInfo.init();
							jorbisComment.init();
							if (joggStreamState.pagein(joggPage) == -1)
							{
								err("Corrupt data (2)");
								return false;
							}

							if (joggStreamState.packetout(joggPacket) != 1)
							{
								err("Corrupt data (3)");
								return false;
							}

							if (jorbisInfo.synthesis_headerin(jorbisComment,
								joggPacket) < 0)
							{
								err("Corrupt data (4)");
								return false;
							}

							packet++;
							break;
						}
					}
					if (packet == 1)
						break;
				}

				case 2:
				case 3:
				{
					switch (joggSyncState.pageout(joggPage))
					{
						case -1:
						{
							err("Corrupt data (5)");
							return false;
						}
						case 0:
						{
							break; //need more
						}
						case 1:
						{
							joggStreamState.pagein(joggPage);
							switch (joggStreamState.packetout(joggPacket))
							{
								case -1:
								{
									err("Corrupt data (6)");
									return false;
								}
								case 0:
								{
									break; //need more
								}
								case 1:
								{
									jorbisInfo.synthesis_headerin(
										jorbisComment, joggPacket);
									packet++;
									if (packet == 4)
									{
										needMoreData = false;
									}
									break;
								}
							}
							break;
						}
					}
					break;
				}
			}

			bIndex = joggSyncState.buffer(bSize);
			buffer = joggSyncState.data;

			if (bCount == 0 && needMoreData)
			{
				err("Truncated data (1)");
				return false;
			}
		}
		return true;
	}

	private boolean initializeSound()
	{
		cbSize = bSize * 2;
		cbuffer = new byte[cbSize];
		jorbisDspState.synthesis_init(jorbisInfo);
		jorbisBlock.init(jorbisDspState);
		int channels = jorbisInfo.channels;
		int rate = jorbisInfo.rate;
		AudioFormat audioFormat = new AudioFormat(
			(float) rate, 16, channels, true, false);
		DataLine.Info datalineInfo = new DataLine.Info(
			SourceDataLine.class, audioFormat, AudioSystem.NOT_SPECIFIED);
		if (!AudioSystem.isLineSupported(datalineInfo))
		{
			err("Sound card failure (1)");
			return false;
		}
		try
		{
			outputLine = (SourceDataLine) AudioSystem.getLine(datalineInfo);
			outputLine.open(audioFormat);
		}
		catch (Exception ex)
		{
			err("outputLine open failed");
			return false;
		}

		outputLine.start();
		pcmData = new float[1][][];
		pcmIndex = new int[jorbisInfo.channels];
		return true;
	}

	private void readBody()
	{
		boolean needMoreData = true;
		while (needMoreData && !gtfo)
		{
			switch (joggSyncState.pageout(joggPage))
			{
				case -1:
				{
					err("Corrupted data (non-fatal-1)");
				}
				case 0:
				{
					break; //need more
				}
				case 1:
				{
					joggStreamState.pagein(joggPage);
					if (joggPage.granulepos() == 0)
					{
						needMoreData = false;
						break;
					}
					processPackets:
					while (true)
					{
						switch (joggStreamState.packetout(joggPacket))
						{
							case -1:
							{
								err("Corrupted data (non-fatal-2)");
							}
							case 0:
							{
								break processPackets; //needmore?
							}
							case 1:
							{
								decodeCurrentPacket();
							}
						}
					}
					if (joggPage.eos() != 0) //eof
						needMoreData = false;
				}
			}

			if (needMoreData)
			{
				bIndex = joggSyncState.buffer(bSize);
				buffer = joggSyncState.data;
				try
				{
					bCount = inputStream.read(buffer, bIndex, bSize);
				}
				catch (Exception e)
				{
					System.err.println(e);
					return;
				}
				joggSyncState.wrote(bCount);
				if (bCount == 0)
				{
					needMoreData = false;
				}
			}
		}
	}

	private void cleanUp()
	{
		joggStreamState.clear();
		jorbisBlock.clear();
		jorbisDspState.clear();
		jorbisInfo.clear();
		joggSyncState.clear();

		// Closes the stream.
		try
		{
			if (inputStream != null)
				inputStream.close();
		}
		catch (Exception e)
		{
		}
	}

	private void decodeCurrentPacket()
	{
		int samples;
		if (jorbisBlock.synthesis(joggPacket) == 0)
		{
			jorbisDspState.synthesis_blockin(jorbisBlock);
		}
		int range;
		while ((samples = jorbisDspState.
			synthesis_pcmout(pcmData, pcmIndex)) > 0)
		{
			if (samples < cbSize)
			{
				range = samples;
			}
			else
			{
				range = cbSize;
			}
			for (int i = 0; i < jorbisInfo.channels; i++)
			{
				int sampleIndex = i * 2;
				for (int j = 0; j < range; j++)
				{
					int value = (int) (pcmData[0][i][pcmIndex[i] + j] * 32767);
					if (value > 32767)
					{
						value = 32767;
					}
					if (value < -32768)
					{
						value = -32768;
					}
					if (value < 0)
						value = value | 32768;
					cbuffer[sampleIndex] = (byte) (value);
					cbuffer[sampleIndex + 1] = (byte) (value >>> 8);
					sampleIndex += 2 * (jorbisInfo.channels);
				}
			}
			outputLine.write(cbuffer, 0, 2 * jorbisInfo.channels * range);
			jorbisDspState.synthesis_read(range);
		}
	}
}
