/*
 * This class is entirely my own work
 * I am proud
 */

package aardwark;
import java.awt.Point;
import java.awt.Color;
import java.awt.Graphics;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import java.io.File;

public class Display extends JPanel {

	private int temp, lumi;
	private String time, tima;

	private boolean en;
	private int readerVar;
	private boolean[][][] chr;
	private BufferedImage base, mask, nask, fade;
	private Point
		pt_chour, pt_cminute, pt_ccol,
		pt_ahour, pt_aminute, pt_acol,
		pt_temp, pt_illu;
	private State reader;

	public enum State
	{
		IDLE, READING, READY, OHNO
	}

	public Display()
	{
		try
		{
			base = ImageIO.read(new File("base.png"));
			mask = ImageIO.read(new File("mask.png"));
			nask = ImageIO.read(new File("nask.png"));
			fade = ImageIO.read(new File("fade.png"));
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		en = false;
		lumi = temp = 0;
		time = tima = "------";
		reader = State.IDLE;

		// mspaint ;_;
		pt_temp = new Point(175, 151);
		pt_illu = new Point(420, 151);
		pt_ccol = new Point(292, 269);
		pt_chour = new Point(132, 249);
		pt_cminute = new Point(332, 249);

		// fuck yes hoderegning
		pt_acol = new Point(296, 402);
		pt_ahour = new Point(216, 392);
		pt_aminute = new Point(316, 392);

		// Valid character set
		String[] chrset =
		{
			"35111101101101111",
			"35010010010010010",
			"35111001111100111",
			"35111001111001111",
			"35101101111001001",
			"35111100111001111",
			"35111100111101111",
			"35111001001001001",
			"35111101111101111",
			"35111101111001001",
			"13101", "13000",
			"35000000111000000"
		};

		// Dimension the character set
		chr = new boolean[chrset.length][][];
		for (int n = 0; n < chrset.length; n++)
		{
			int width = chrset[n].charAt(0) - '0';
			int height = chrset[n].charAt(1) - '0';

			chr[n] = new boolean[height][];
			for (int y = 0; y < height; y++)
			{
				// Dimension the horizontal space
				chr[n][y] = new boolean[width];
				for (int x = 0; x < width; x++)
				{
					// Define pixel on or off
					chr[n][y][x] = chrset[n].charAt(y * width + x + 2) == '1';
				}
			}
		}
	}

	private Point clone(Point pt)
	{
		return new Point(pt.x, pt.y);
	}

	public void updateDisplay(
		String time, String tima,
		int temp, int lumi, boolean on)
	{
		this.en = on;
		this.lumi = lumi;
		this.temp = temp;
		this.time = time;
		this.tima = tima; // u mena tima?
	}

	public int getButton(Point pt)
	{
		//return (mask.getRGB(pt.x, pt.y) / 0x1000000) / -10;
		return (mask.getRGB(pt.x, pt.y) / 0x10000 + 256) / 0x10;
	}

	@Override
	public void paintComponent(Graphics g)
	{
		g.setColor(Color.white);
		g.fillRect(0, 0, 600, 600);
		g.drawImage(base, 0, 0, null);

		Point o_col = clone(pt_ccol);
		Point o_hour = clone(pt_chour);
		Point o_minute = clone(pt_cminute);

		if (time.contains("----"))
		{
			paintLetter(g, 12, 20, 1.0, o_hour);
			paintLetter(g, 12, 20, 1.0, o_hour);
			paintLetter(g, 12, 20, 1.0, o_minute);
			paintLetter(g, 12, 20, 1.0, o_minute);
		}
		else
		{
			int h = Integer.parseInt(time.substring(0, 2));
			int m = Integer.parseInt(time.substring(2, 4));
			int s = Integer.parseInt(time.substring(4, 6));

			paintLetter(g, h / 10, 20, 1.0, o_hour);
			paintLetter(g, h % 10, 20, 1.0, o_hour);
			paintLetter(g, m / 10, 20, 1.0, o_minute);
			paintLetter(g, m % 10, 20, 1.0, o_minute);
			paintLetter(g, 10 + s % 2, 20, 1.0, o_col);
		}

		o_col = clone(pt_acol);
		o_hour = clone(pt_ahour);
		o_minute = clone(pt_aminute);

		double a = en? 1: 0.7;
		if (tima.contains("----"))
		{
			paintLetter(g, 12, 10, 1.0, o_hour);
			paintLetter(g, 12, 10, 1.0, o_hour);
			paintLetter(g, 12, 10, 1.0, o_minute);
			paintLetter(g, 12, 10, 1.0, o_minute);
		}
		else
		{
			int h = Integer.parseInt(tima.substring(0, 2));
			int m = Integer.parseInt(tima.substring(2, 4));
		
			paintLetter(g, h / 10, 10, a, o_hour);
			paintLetter(g, h % 10, 10, a, o_hour);
			paintLetter(g, m / 10, 10, a, o_minute);
			paintLetter(g, m % 10, 10, a, o_minute);
			paintLetter(g, 10, 10, a, o_col);
		}

		int steps, v;
		Point o_temp = clone(pt_temp);
		Point o_illu = clone(pt_illu);

		v = temp;
		steps = ("" + temp).length();
		while (--steps >= 0)
		{
			int n = v / (int)Math.pow(10, steps);
			paintLetter(g, n, 10, 1.0, o_temp);
			v -= n * Math.pow(10, steps);
		}

		v = lumi;
		steps = ("" + lumi).length();
		o_illu.x -= 40 * steps;
		while (--steps >= 0)
		{
			int n = v / (int)Math.pow(10, steps);
			paintLetter(g, n, 10, 1.0, o_illu);
			v -= n * Math.pow(10, steps);
		}

		if (reader == State.READING)
		{
			//g.setColor(new Color(255, 255, 255, 192));
			//g.fillRect(0, 0, 600, 600);
			g.drawImage(fade, 0, 0, null);

			Point pt; //SHADOWS.
			for (int i = 2; i >= 0; i -= 2) {
				pt = new Point(177+i, 130+i);
				paintLetter(g, 1, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 2, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 3, 15, 1.0, i/2, pt);

				pt = new Point(177+i, 230+i);
				paintLetter(g, 4, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 5, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 6, 15, 1.0, i/2, pt);

				pt = new Point(177+i, 330+i);
				paintLetter(g, 7, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 8, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 9, 15, 1.0, i/2, pt);

				pt = new Point(177+i, 430+i);
				paintLetter(g, 0, 15, 0.0, i/2, pt); pt.x += 40;
				paintLetter(g, 0, 15, 1.0, i/2, pt); pt.x += 40;
				paintLetter(g, 0, 15, 0.0, i/2, pt);
			}
		}
	}

	/**
	 * Draw a single letter onto the display
	 * @param g The graphics object to target
	 * @param n Chracter indice in the character set
	 * @param sz Segment size (pixel amplification)
	 * @param pt Offset to initiate drawing from
	 */
	private void paintLetter(Graphics g, int n, int sz, double mul, Point pt)
	{
		Point ptb = new Point(pt.x+1, pt.y+1);
		paintLetter(g, n, sz, mul*0.6, 1, ptb);
		paintLetter(g, n, sz, mul*1.0, 0, pt);
	}

	private void paintLetter(Graphics g, int n, int sz, double mul, int ci, Point pt)
	{
		int[] seg = { 255, 0 };
		Color on = new Color(seg[ci], seg[ci], seg[ci], (int)(240 * mul));
		Color off = new Color(seg[ci], seg[ci], seg[ci], (int)(24 * mul));

		for (int y = 0; y < chr[n].length; y++)
		{
			for (int x = 0; x < chr[n][y].length; x++)
			{
				g.setColor(chr[n][y][x] ? on : off);
				g.fillRect(
					pt.x + x * sz,
					pt.y + y * sz,
					sz - sz / 10,
					sz - sz / 10);
			}
		}
		pt.x += sz * 4;
	}

	public void read()
	{
		readerVar = 0;
		reader = State.READING;
	}

	public State readerState(Point pt)
	{
		if (reader == State.IDLE) return State.IDLE;
		if (reader == State.READY)
		{
			// Target objekt selected, indicate and pass on
			reader = State.IDLE;
			return State.READY;
		}
		int btn = (nask.getRGB(pt.x, pt.y) / 0x10000 + 256) / 0x10;
		if (btn == 0 || btn == 11)
		{
			readerVar = 0;
			reader = State.IDLE;
			return State.IDLE;
		}
		if (btn <= 10)
		{
			if (btn == 10) btn = 0;
			readerVar = readerVar * 10 + btn;
			return State.READING;
		}
		if (btn == 12)
		{
			// Entry confirmed, next entry is target object
			reader = State.READY;
			return State.READING;
		}
		return State.OHNO;
	}

	public int getRead()
	{
		return readerVar;
	}
}
