package aardwark;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;

public class AardwarkView extends FrameView
{
	public AardwarkView(SingleFrameApplication app)
	{
		super(app);
		initComponents();
		main();
	}
	private Speaker spk;
	private TimeChip timeChip;
	private TempChip tempChip;
	private LumiChip lumiChip;
	private int skupdate;

	private void main()
	{
		skupdate = 0;
		timeChip = new TimeChip();
		tempChip = new TempChip();
		lumiChip = new LumiChip();
		spk = new Speaker("wake.ogg");
		java.util.Timer refresh = new java.util.Timer(true);
		java.util.TimerTask refresher = new java.util.TimerTask()
		{
			@Override
			public void run()
			{
				redrawDisplay();
				display1.repaint();
				if (spk.playing()) return;

				if (lumiChip.getLumi() > timeChip.limLumi())
				{
					spk.start();
					timeChip.setAlarm(false);
				}
				if (timeChip.soundAlarm())
				{
					if (tempChip.getTemp() < timeChip.limTemp())
					{
						timeChip.setAlarm(1 * 60 * 60);
					}
					else
					{
						spk.start();
						timeChip.setAlarm(false);
					}
				}
			}
		};
		refresh.scheduleAtFixedRate(refresher, 1000, 1000);
	}

	private void redrawDisplay()
	{
		if (skupdate > 0)
		{
			skupdate--;
			return;
		}
		display1.updateDisplay(
			timeChip.getTime(),
			timeChip.getAlarm(),
			tempChip.getTemp(),
			lumiChip.getLumi(),
			timeChip.enabled());
		display1.repaint();
	}

	/*
	 * AUTOGENERATED BULLSHIT BEYOND THIS POINT
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        display1 = new aardwark.Display();
        jLabel1 = new javax.swing.JLabel();
        jSpinner1 = new javax.swing.JSpinner();
        jSpinner2 = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();

        mainPanel.setName("mainPanel"); // NOI18N

        display1.setName("display1"); // NOI18N
        display1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                handleScreenEvent(evt);
            }
        });

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(aardwark.AardwarkApp.class).getContext().getResourceMap(AardwarkView.class);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jSpinner1.setModel(new javax.swing.SpinnerNumberModel(72, 0, 99, 1));
        jSpinner1.setName("jSpinner1"); // NOI18N
        jSpinner1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                simulatorLight(evt);
            }
        });

        jSpinner2.setModel(new javax.swing.SpinnerNumberModel(19, 0, 99, 1));
        jSpinner2.setName("jSpinner2"); // NOI18N
        jSpinner2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                simulatorTemp(evt);
            }
        });

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        javax.swing.GroupLayout display1Layout = new javax.swing.GroupLayout(display1);
        display1.setLayout(display1Layout);
        display1Layout.setHorizontalGroup(
            display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(display1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jSpinner1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSpinner2, javax.swing.GroupLayout.Alignment.LEADING))
                .addGap(4, 4, 4)
                .addGroup(display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addContainerGap(525, Short.MAX_VALUE))
        );
        display1Layout.setVerticalGroup(
            display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(display1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jSpinner2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(display1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jSpinner1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addContainerGap(526, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(display1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(display1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        setComponent(mainPanel);
    }// </editor-fold>//GEN-END:initComponents
	/*
	 * AUTOGENERATED BULLSHIT ABOVE THIS POINT
	 */

	private void simulatorLight(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_simulatorLight
	{//GEN-HEADEREND:event_simulatorLight
		//SpinnerNumberModel snm = new SpinnerNumberModel();
		//illuChip.setLumi(snm.getNumber(jSpinner1.getValue()));
		lumiChip.setLumi(Integer.parseInt(jSpinner1.getValue().toString()));
		// WHY THE HELL DOES THIS EVEN NECESSARY
		// FUCK THIS LANGUAGE

		redrawDisplay();
	}//GEN-LAST:event_simulatorLight

	private void simulatorTemp(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_simulatorTemp
	{//GEN-HEADEREND:event_simulatorTemp
		tempChip.setTemp(Integer.parseInt(jSpinner2.getValue().toString()));
		redrawDisplay();
	}//GEN-LAST:event_simulatorTemp

	private void handleScreenEvent(java.awt.event.MouseEvent evt)//GEN-FIRST:event_handleScreenEvent
	{//GEN-HEADEREND:event_handleScreenEvent
		Display.State read = display1.readerState(evt.getPoint());
		if (read == Display.State.READING)
		{
			// currently reading digits, gtfo
			display1.repaint();
			return;
		}
		// operation depending on regular-gui, identify:
		int btn = display1.getButton(evt.getPoint());

		if (read == Display.State.READY)
		{
			// read completed; store value
			int var = display1.getRead();

			if (btn == 1 || btn == 2)
			{
				setTitle("Temperature limit set to " + var);
				timeChip.limTemp(var);
			}
			else if (btn == 3 || btn == 4)
			{
				setTitle("Luminosity limit set to " + var);
				timeChip.limLumi(var);
			}
			else if (btn == 5 || btn == 6)
			{
				setTitle("Alarm time set to " + var);
				timeChip.setAlarm(String.format("%04d", var));
			}
			else
			{
				javax.swing.JOptionPane.showMessageDialog(
					null, var + " doesn't fit there brah");
			}
		}
		if (read == Display.State.IDLE)
		{
			// regular gui mōdō, commence regular operation
			String[] buttons = {
				"-",
				"icon_temp",
				"value_temp",
				"icon_lumi",
				"value_lumi",
				"hour",
				"minute",
				"snooze",
				"toggle"
			};
			skupdate = 0;
			setTitle(btn + "> " + buttons[btn]);
			if (btn == 1)
			{
				int var = tempChip.getTemp();
				setTitle("Temperature limit set to " + var);
				timeChip.limTemp(var);
			}
			else if (btn == 3)
			{
				int var = lumiChip.getLumi();
				setTitle("Luminosity limit set to " + var);
				lumiChip.setLumi(var);
			}
			else if (btn == 7)
			{
				if (spk.playing())
				{
					spk.stop();
					timeChip.setAlarm(5 * 60);
				}
				else
				{
					display1.read();
					//display1.repaint();
				}
			}
			else if (btn == 8)
			{
				boolean enabled = !timeChip.enabled();

				timeChip.setAlarm(enabled);
				setTitle("Alarm " + (enabled?"enabled":"disabled"));
				if (enabled)
				{
					skupdate = 31;
					display1.updateDisplay(
						timeChip.getAlarm(),
						"----",
						timeChip.limTemp(),
						timeChip.limLumi(),
						true);
					display1.repaint();
				}
			}
		}
		redrawDisplay();
	}//GEN-LAST:event_handleScreenEvent

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private aardwark.Display display1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JSpinner jSpinner1;
    private javax.swing.JSpinner jSpinner2;
    private javax.swing.JPanel mainPanel;
    // End of variables declaration//GEN-END:variables

	private void setTitle(String string)
	{
		this.getFrame().setTitle(string); //WHAT.
	}
}
