/*
 * Decompiled with CFR 0.152.
 */
package aardwark;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeChip {
    private SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
    private int limLumi = 75;
    private int limTemp = 17;
    private int alarmBase = 700;
    private long alarmUT;

    public String getTime() {
        return this.sdf.format(System.currentTimeMillis());
    }

    public String getAlarm() {
        if (this.alarmUT > 0L) {
            return this.sdf.format(this.alarmUT);
        }
        int m = this.alarmBase % 100;
        int h = this.alarmBase / 100;
        return String.format("%02d%02d", h, m);
    }

    public boolean enabled() {
        return this.alarmUT > 0L;
    }

    public void setAlarm(String time) {
        this.alarmUT = 0L;
        int h = Integer.parseInt(time.substring(0, 2));
        int m = Integer.parseInt(time.substring(2, 4));
        this.alarmBase = h * 100 + m;
    }

    public void setAlarm(int distance) {
        Calendar now = Calendar.getInstance();
        now.add(13, distance);
        this.alarmUT = now.getTimeInMillis();
    }

    public void setAlarm(boolean enabled) {
        if (!enabled) {
            this.alarmUT = 0L;
        } else {
            int m = this.alarmBase % 100;
            int h = this.alarmBase / 100;
            Calendar now = Calendar.getInstance();
            Calendar zilch = Calendar.getInstance();
            zilch.set(now.get(1), now.get(2), now.get(5), h, m, 0);
            if (zilch.before(now)) {
                zilch.add(11, 24);
            }
            this.alarmUT = zilch.getTimeInMillis();
        }
    }

    public int limLumi() {
        return this.limLumi;
    }

    public void limLumi(int i) {
        this.limLumi = i;
    }

    public int limTemp() {
        return this.limTemp;
    }

    public void limTemp(int i) {
        this.limTemp = i;
    }

    public boolean soundAlarm() {
        return this.alarmUT > 0L && this.alarmUT <= System.currentTimeMillis();
    }
}

