/*
 * Decompiled with CFR 0.152.
 */
package aardwark;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class OggCodec
extends Thread {
    private boolean gtfo;
    private InputStream inputStream = null;
    private byte[] buffer = null;
    private int bSize = 2048;
    private int bCount = 0;
    private int bIndex = 0;
    private byte[] cbuffer = null;
    private int cbSize;
    private SourceDataLine outputLine = null;
    private float[][][] pcmData;
    private int[] pcmIndex;
    private long started = -1L;
    private Packet joggPacket = new Packet();
    private Page joggPage = new Page();
    private StreamState joggStreamState = new StreamState();
    private SyncState joggSyncState = new SyncState();
    private DspState jorbisDspState = new DspState();
    private Block jorbisBlock = new Block(this.jorbisDspState);
    private Comment jorbisComment = new Comment();
    private Info jorbisInfo = new Info();

    public OggCodec(String filename) {
        try {
            this.inputStream = new FileInputStream(filename);
        }
        catch (Exception ex) {
            this.err("File not found");
        }
        this.start();
    }

    public void stopit() {
        this.gtfo = true;
    }

    private void err(String msg) {
        System.err.println(msg);
    }

    public void run() {
        if (this.inputStream == null) {
            this.err("No opened stream = nothing to do");
            return;
        }
        this.initializeJOrbis();
        if (this.readHeader() && this.initializeSound()) {
            this.readBody();
        }
        this.gtfo = true;
        this.cleanUp();
    }

    public boolean isPlaying() {
        return !this.gtfo;
    }

    private void initializeJOrbis() {
        this.joggSyncState.init();
        this.joggSyncState.buffer(this.bSize);
        this.buffer = this.joggSyncState.data;
    }

    private boolean readHeader() {
        boolean needMoreData = true;
        int packet = 1;
        while (needMoreData) {
            try {
                this.bCount = this.inputStream.read(this.buffer, this.bIndex, this.bSize);
            }
            catch (Exception ex) {
                this.err("File reading failed");
            }
            this.joggSyncState.wrote(this.bCount);
            block1 : switch (packet) {
                case 1: {
                    switch (this.joggSyncState.pageout(this.joggPage)) {
                        case -1: {
                            this.err("Corrupt data (1)");
                            return false;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.joggStreamState.init(this.joggPage.serialno());
                            this.joggStreamState.reset();
                            this.jorbisInfo.init();
                            this.jorbisComment.init();
                            if (this.joggStreamState.pagein(this.joggPage) == -1) {
                                this.err("Corrupt data (2)");
                                return false;
                            }
                            if (this.joggStreamState.packetout(this.joggPacket) != 1) {
                                this.err("Corrupt data (3)");
                                return false;
                            }
                            if (this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket) < 0) {
                                this.err("Corrupt data (4)");
                                return false;
                            }
                            ++packet;
                        }
                    }
                    if (packet == 1) break;
                }
                case 2: 
                case 3: {
                    switch (this.joggSyncState.pageout(this.joggPage)) {
                        case -1: {
                            this.err("Corrupt data (5)");
                            return false;
                        }
                        case 0: {
                            break block1;
                        }
                        case 1: {
                            this.joggStreamState.pagein(this.joggPage);
                            switch (this.joggStreamState.packetout(this.joggPacket)) {
                                case -1: {
                                    this.err("Corrupt data (6)");
                                    return false;
                                }
                                case 0: {
                                    break block1;
                                }
                                case 1: {
                                    this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket);
                                    if (++packet != 4) break block1;
                                    needMoreData = false;
                                }
                            }
                        }
                    }
                }
            }
            this.bIndex = this.joggSyncState.buffer(this.bSize);
            this.buffer = this.joggSyncState.data;
            if (this.bCount != 0 || !needMoreData) continue;
            this.err("Truncated data (1)");
            return false;
        }
        return true;
    }

    private boolean initializeSound() {
        this.cbSize = this.bSize * 2;
        this.cbuffer = new byte[this.cbSize];
        this.jorbisDspState.synthesis_init(this.jorbisInfo);
        this.jorbisBlock.init(this.jorbisDspState);
        int channels = this.jorbisInfo.channels;
        int rate = this.jorbisInfo.rate;
        AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
        DataLine.Info datalineInfo = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
        if (!AudioSystem.isLineSupported(datalineInfo)) {
            this.err("Sound card failure (1)");
            return false;
        }
        try {
            this.outputLine = (SourceDataLine)AudioSystem.getLine(datalineInfo);
            this.outputLine.open(audioFormat);
        }
        catch (Exception ex) {
            this.err("outputLine open failed");
            return false;
        }
        this.outputLine.start();
        this.pcmData = new float[1][][];
        this.pcmIndex = new int[this.jorbisInfo.channels];
        return true;
    }

    private void readBody() {
        boolean needMoreData = true;
        while (needMoreData && !this.gtfo) {
            switch (this.joggSyncState.pageout(this.joggPage)) {
                case -1: {
                    this.err("Corrupted data (non-fatal-1)");
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.joggStreamState.pagein(this.joggPage);
                    if (this.joggPage.granulepos() == 0L) {
                        needMoreData = false;
                        break;
                    }
                    block13: while (true) {
                        switch (this.joggStreamState.packetout(this.joggPacket)) {
                            case -1: {
                                this.err("Corrupted data (non-fatal-2)");
                            }
                            case 0: {
                                break block13;
                            }
                            case 1: {
                                this.decodeCurrentPacket();
                            }
                            default: {
                                continue block13;
                            }
                        }
                        break;
                    }
                    if (this.joggPage.eos() == 0) break;
                    needMoreData = false;
                }
            }
            if (!needMoreData) continue;
            this.bIndex = this.joggSyncState.buffer(this.bSize);
            this.buffer = this.joggSyncState.data;
            try {
                this.bCount = this.inputStream.read(this.buffer, this.bIndex, this.bSize);
            }
            catch (Exception e) {
                System.err.println(e);
                return;
            }
            this.joggSyncState.wrote(this.bCount);
            if (this.bCount != 0) continue;
            needMoreData = false;
        }
    }

    private void cleanUp() {
        this.joggStreamState.clear();
        this.jorbisBlock.clear();
        this.jorbisDspState.clear();
        this.jorbisInfo.clear();
        this.joggSyncState.clear();
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void decodeCurrentPacket() {
        int samples;
        if (this.jorbisBlock.synthesis(this.joggPacket) == 0) {
            this.jorbisDspState.synthesis_blockin(this.jorbisBlock);
        }
        while ((samples = this.jorbisDspState.synthesis_pcmout(this.pcmData, this.pcmIndex)) > 0) {
            int range = samples < this.cbSize ? samples : this.cbSize;
            for (int i = 0; i < this.jorbisInfo.channels; ++i) {
                int sampleIndex = i * 2;
                for (int j = 0; j < range; ++j) {
                    int value = (int)(this.pcmData[0][i][this.pcmIndex[i] + j] * 32767.0f);
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    }
                    if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    if (value < 0) {
                        value |= 0x8000;
                    }
                    this.cbuffer[sampleIndex] = (byte)value;
                    this.cbuffer[sampleIndex + 1] = (byte)(value >>> 8);
                    sampleIndex += 2 * this.jorbisInfo.channels;
                }
            }
            this.outputLine.write(this.cbuffer, 0, 2 * this.jorbisInfo.channels * range);
            this.jorbisDspState.synthesis_read(range);
        }
    }
}

