/*
 * Decompiled with CFR 0.152.
 */
package aardwark;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Display
extends JPanel {
    private int temp;
    private int lumi;
    private String time;
    private String tima;
    private boolean en;
    private int readerVar;
    private boolean[][][] chr;
    private BufferedImage base;
    private BufferedImage mask;
    private BufferedImage nask;
    private BufferedImage fade;
    private Point pt_chour;
    private Point pt_cminute;
    private Point pt_ccol;
    private Point pt_ahour;
    private Point pt_aminute;
    private Point pt_acol;
    private Point pt_temp;
    private Point pt_illu;
    private State reader;

    public Display() {
        try {
            this.base = ImageIO.read(new File("base.png"));
            this.mask = ImageIO.read(new File("mask.png"));
            this.nask = ImageIO.read(new File("nask.png"));
            this.fade = ImageIO.read(new File("fade.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.en = false;
        this.temp = 0;
        this.lumi = 0;
        this.tima = "------";
        this.time = "------";
        this.reader = State.IDLE;
        this.pt_temp = new Point(175, 151);
        this.pt_illu = new Point(420, 151);
        this.pt_ccol = new Point(292, 269);
        this.pt_chour = new Point(132, 249);
        this.pt_cminute = new Point(332, 249);
        this.pt_acol = new Point(296, 402);
        this.pt_ahour = new Point(216, 392);
        this.pt_aminute = new Point(316, 392);
        String[] chrset = new String[]{"35111101101101111", "35010010010010010", "35111001111100111", "35111001111001111", "35101101111001001", "35111100111001111", "35111100111101111", "35111001001001001", "35111101111101111", "35111101111001001", "13101", "13000", "35000000111000000"};
        this.chr = new boolean[chrset.length][][];
        for (int n = 0; n < chrset.length; ++n) {
            int width = chrset[n].charAt(0) - 48;
            int height = chrset[n].charAt(1) - 48;
            this.chr[n] = new boolean[height][];
            for (int y = 0; y < height; ++y) {
                this.chr[n][y] = new boolean[width];
                for (int x = 0; x < width; ++x) {
                    this.chr[n][y][x] = chrset[n].charAt(y * width + x + 2) == '1';
                }
            }
        }
    }

    private Point clone(Point pt) {
        return new Point(pt.x, pt.y);
    }

    public void updateDisplay(String time, String tima, int temp, int lumi, boolean on) {
        this.en = on;
        this.lumi = lumi;
        this.temp = temp;
        this.time = time;
        this.tima = tima;
    }

    public int getButton(Point pt) {
        return (this.mask.getRGB(pt.x, pt.y) / 65536 + 256) / 16;
    }

    public void paintComponent(Graphics g) {
        int n;
        double a;
        g.setColor(Color.white);
        g.fillRect(0, 0, 600, 600);
        g.drawImage(this.base, 0, 0, null);
        Point o_col = this.clone(this.pt_ccol);
        Point o_hour = this.clone(this.pt_chour);
        Point o_minute = this.clone(this.pt_cminute);
        if (this.time.contains("----")) {
            this.paintLetter(g, 12, 20, 1.0, o_hour);
            this.paintLetter(g, 12, 20, 1.0, o_hour);
            this.paintLetter(g, 12, 20, 1.0, o_minute);
            this.paintLetter(g, 12, 20, 1.0, o_minute);
        } else {
            int h = Integer.parseInt(this.time.substring(0, 2));
            int m = Integer.parseInt(this.time.substring(2, 4));
            int s = Integer.parseInt(this.time.substring(4, 6));
            this.paintLetter(g, h / 10, 20, 1.0, o_hour);
            this.paintLetter(g, h % 10, 20, 1.0, o_hour);
            this.paintLetter(g, m / 10, 20, 1.0, o_minute);
            this.paintLetter(g, m % 10, 20, 1.0, o_minute);
            this.paintLetter(g, 10 + s % 2, 20, 1.0, o_col);
        }
        o_col = this.clone(this.pt_acol);
        o_hour = this.clone(this.pt_ahour);
        o_minute = this.clone(this.pt_aminute);
        double d = a = this.en ? 1.0 : 0.7;
        if (this.tima.contains("----")) {
            this.paintLetter(g, 12, 10, 1.0, o_hour);
            this.paintLetter(g, 12, 10, 1.0, o_hour);
            this.paintLetter(g, 12, 10, 1.0, o_minute);
            this.paintLetter(g, 12, 10, 1.0, o_minute);
        } else {
            int h = Integer.parseInt(this.tima.substring(0, 2));
            int m = Integer.parseInt(this.tima.substring(2, 4));
            this.paintLetter(g, h / 10, 10, a, o_hour);
            this.paintLetter(g, h % 10, 10, a, o_hour);
            this.paintLetter(g, m / 10, 10, a, o_minute);
            this.paintLetter(g, m % 10, 10, a, o_minute);
            this.paintLetter(g, 10, 10, a, o_col);
        }
        Point o_temp = this.clone(this.pt_temp);
        Point o_illu = this.clone(this.pt_illu);
        int v = this.temp;
        int steps = ("" + this.temp).length();
        while (--steps >= 0) {
            n = v / (int)Math.pow(10.0, steps);
            this.paintLetter(g, n, 10, 1.0, o_temp);
            v = (int)((double)v - (double)n * Math.pow(10.0, steps));
        }
        v = this.lumi;
        steps = ("" + this.lumi).length();
        o_illu.x -= 40 * steps;
        while (--steps >= 0) {
            n = v / (int)Math.pow(10.0, steps);
            this.paintLetter(g, n, 10, 1.0, o_illu);
            v = (int)((double)v - (double)n * Math.pow(10.0, steps));
        }
        if (this.reader == State.READING) {
            g.drawImage(this.fade, 0, 0, null);
            for (int i = 2; i >= 0; i -= 2) {
                Point pt = new Point(177 + i, 130 + i);
                this.paintLetter(g, 1, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 2, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 3, 15, 1.0, i / 2, pt);
                pt = new Point(177 + i, 230 + i);
                this.paintLetter(g, 4, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 5, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 6, 15, 1.0, i / 2, pt);
                pt = new Point(177 + i, 330 + i);
                this.paintLetter(g, 7, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 8, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 9, 15, 1.0, i / 2, pt);
                pt = new Point(177 + i, 430 + i);
                this.paintLetter(g, 0, 15, 0.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 0, 15, 1.0, i / 2, pt);
                pt.x += 40;
                this.paintLetter(g, 0, 15, 0.0, i / 2, pt);
            }
        }
    }

    private void paintLetter(Graphics g, int n, int sz, double mul, Point pt) {
        Point ptb = new Point(pt.x + 1, pt.y + 1);
        this.paintLetter(g, n, sz, mul * 0.6, 1, ptb);
        this.paintLetter(g, n, sz, mul * 1.0, 0, pt);
    }

    private void paintLetter(Graphics g, int n, int sz, double mul, int ci, Point pt) {
        int[] seg = new int[]{255, 0};
        Color on = new Color(seg[ci], seg[ci], seg[ci], (int)(240.0 * mul));
        Color off = new Color(seg[ci], seg[ci], seg[ci], (int)(24.0 * mul));
        for (int y = 0; y < this.chr[n].length; ++y) {
            for (int x = 0; x < this.chr[n][y].length; ++x) {
                g.setColor(this.chr[n][y][x] ? on : off);
                g.fillRect(pt.x + x * sz, pt.y + y * sz, sz - sz / 10, sz - sz / 10);
            }
        }
        pt.x += sz * 4;
    }

    public void read() {
        this.readerVar = 0;
        this.reader = State.READING;
    }

    public State readerState(Point pt) {
        if (this.reader == State.IDLE) {
            return State.IDLE;
        }
        if (this.reader == State.READY) {
            this.reader = State.IDLE;
            return State.READY;
        }
        int btn = (this.nask.getRGB(pt.x, pt.y) / 65536 + 256) / 16;
        if (btn == 0 || btn == 11) {
            this.readerVar = 0;
            this.reader = State.IDLE;
            return State.IDLE;
        }
        if (btn <= 10) {
            if (btn == 10) {
                btn = 0;
            }
            this.readerVar = this.readerVar * 10 + btn;
            return State.READING;
        }
        if (btn == 12) {
            this.reader = State.READY;
            return State.READING;
        }
        return State.OHNO;
    }

    public int getRead() {
        return this.readerVar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        READING,
        READY,
        OHNO;

    }
}

