/*
 * Decompiled with CFR 0.152.
 */
package aardwark;

import aardwark.AardwarkApp;
import aardwark.Display;
import aardwark.LumiChip;
import aardwark.Speaker;
import aardwark.TempChip;
import aardwark.TimeChip;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class AardwarkView
extends FrameView {
    private Speaker spk;
    private TimeChip timeChip;
    private TempChip tempChip;
    private LumiChip lumiChip;
    private int skupdate;
    private Display display1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JPanel mainPanel;

    public AardwarkView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.main();
    }

    private void main() {
        this.skupdate = 0;
        this.timeChip = new TimeChip();
        this.tempChip = new TempChip();
        this.lumiChip = new LumiChip();
        this.spk = new Speaker("wake.ogg");
        Timer refresh = new Timer(true);
        TimerTask refresher = new TimerTask(){

            public void run() {
                AardwarkView.this.redrawDisplay();
                AardwarkView.this.display1.repaint();
                if (AardwarkView.this.spk.playing()) {
                    return;
                }
                if (AardwarkView.this.lumiChip.getLumi() > AardwarkView.this.timeChip.limLumi()) {
                    AardwarkView.this.spk.start();
                    AardwarkView.this.timeChip.setAlarm(false);
                }
                if (AardwarkView.this.timeChip.soundAlarm()) {
                    if (AardwarkView.this.tempChip.getTemp() < AardwarkView.this.timeChip.limTemp()) {
                        AardwarkView.this.timeChip.setAlarm(3600);
                    } else {
                        AardwarkView.this.spk.start();
                        AardwarkView.this.timeChip.setAlarm(false);
                    }
                }
            }
        };
        refresh.scheduleAtFixedRate(refresher, 1000L, 1000L);
    }

    private void redrawDisplay() {
        if (this.skupdate > 0) {
            --this.skupdate;
            return;
        }
        this.display1.updateDisplay(this.timeChip.getTime(), this.timeChip.getAlarm(), this.tempChip.getTemp(), this.lumiChip.getLumi(), this.timeChip.enabled());
        this.display1.repaint();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.display1 = new Display();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jSpinner2 = new JSpinner();
        this.jLabel2 = new JLabel();
        this.mainPanel.setName("mainPanel");
        this.display1.setName("display1");
        this.display1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AardwarkView.this.handleScreenEvent(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(AardwarkApp.class).getContext().getResourceMap(AardwarkView.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jSpinner1.setModel(new SpinnerNumberModel(72, 0, 99, 1));
        this.jSpinner1.setName("jSpinner1");
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AardwarkView.this.simulatorLight(evt);
            }
        });
        this.jSpinner2.setModel(new SpinnerNumberModel(19, 0, 99, 1));
        this.jSpinner2.setName("jSpinner2");
        this.jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AardwarkView.this.simulatorTemp(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        GroupLayout display1Layout = new GroupLayout(this.display1);
        this.display1.setLayout(display1Layout);
        display1Layout.setHorizontalGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(display1Layout.createSequentialGroup().addContainerGap().addGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSpinner1, GroupLayout.Alignment.LEADING).addComponent(this.jSpinner2, GroupLayout.Alignment.LEADING)).addGap(4, 4, 4).addGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addContainerGap(525, Short.MAX_VALUE)));
        display1Layout.setVerticalGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(display1Layout.createSequentialGroup().addContainerGap().addGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(display1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(526, Short.MAX_VALUE)));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.display1, -1, -1, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.display1, -1, -1, Short.MAX_VALUE));
        this.setComponent(this.mainPanel);
    }

    private void simulatorLight(ChangeEvent evt) {
        this.lumiChip.setLumi(Integer.parseInt(this.jSpinner1.getValue().toString()));
        this.redrawDisplay();
    }

    private void simulatorTemp(ChangeEvent evt) {
        this.tempChip.setTemp(Integer.parseInt(this.jSpinner2.getValue().toString()));
        this.redrawDisplay();
    }

    private void handleScreenEvent(MouseEvent evt) {
        Display.State read = this.display1.readerState(evt.getPoint());
        if (read == Display.State.READING) {
            this.display1.repaint();
            return;
        }
        int btn = this.display1.getButton(evt.getPoint());
        if (read == Display.State.READY) {
            int var = this.display1.getRead();
            if (btn == 1 || btn == 2) {
                this.setTitle("Temperature limit set to " + var);
                this.timeChip.limTemp(var);
            } else if (btn == 3 || btn == 4) {
                this.setTitle("Luminosity limit set to " + var);
                this.timeChip.limLumi(var);
            } else if (btn == 5 || btn == 6) {
                this.setTitle("Alarm time set to " + var);
                this.timeChip.setAlarm(String.format("%04d", var));
            } else {
                JOptionPane.showMessageDialog(null, var + " doesn't fit there brah");
            }
        }
        if (read == Display.State.IDLE) {
            String[] buttons = new String[]{"-", "icon_temp", "value_temp", "icon_lumi", "value_lumi", "hour", "minute", "snooze", "toggle"};
            this.skupdate = 0;
            this.setTitle(btn + "> " + buttons[btn]);
            if (btn == 1) {
                int var = this.tempChip.getTemp();
                this.setTitle("Temperature limit set to " + var);
                this.timeChip.limTemp(var);
            } else if (btn == 3) {
                int var = this.lumiChip.getLumi();
                this.setTitle("Luminosity limit set to " + var);
                this.lumiChip.setLumi(var);
            } else if (btn == 7) {
                if (this.spk.playing()) {
                    this.spk.stop();
                    this.timeChip.setAlarm(300);
                } else {
                    this.display1.read();
                }
            } else if (btn == 8) {
                boolean enabled = !this.timeChip.enabled();
                this.timeChip.setAlarm(enabled);
                this.setTitle("Alarm " + (enabled ? "enabled" : "disabled"));
                if (enabled) {
                    this.skupdate = 31;
                    this.display1.updateDisplay(this.timeChip.getAlarm(), "----", this.timeChip.limTemp(), this.timeChip.limLumi(), true);
                    this.display1.repaint();
                }
            }
        }
        this.redrawDisplay();
    }

    private void setTitle(String string) {
        this.getFrame().setTitle(string);
    }
}

