/*
 * Decompiled with CFR 0.152.
 */
package tervis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import tervis.Graph;
import tervis.SortBubble;
import tervis.SortEd;
import tervis.SortQuick;
import tervis.SortShell;
import tervis.SortStooge;
import tervis.SortWut;
import tervis.TervisAboutBox;
import tervis.TervisApp;
import tervis.Toolkit;

public class TervisView
extends FrameView {
    int[] items;
    Graph graph;
    final int COLUMNS = 16;
    private JMenuItem g_bubble;
    private JMenuItem g_ed;
    private JMenuItem g_quick;
    private JMenuItem g_shell;
    private JMenuItem g_shuffle;
    private JMenuItem g_specfy;
    private JMenuItem g_speed;
    private JMenuItem g_stooge;
    private JMenuItem g_wut;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public TervisView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TervisView.this.busyIconIndex = (TervisView.this.busyIconIndex + 1) % TervisView.this.busyIcons.length;
            }
        });
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!TervisView.this.busyIconTimer.isRunning()) {
                        TervisView.this.busyIconIndex = 0;
                        TervisView.this.busyIconTimer.start();
                    }
                } else if ("done".equals(propertyName)) {
                    TervisView.this.busyIconTimer.stop();
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    TervisView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int n = (Integer)evt.getNewValue();
                }
            }
        });
        this.init();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = TervisApp.getApplication().getMainFrame();
            this.aboutBox = new TervisAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        TervisApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.g_speed = new JMenuItem();
        this.g_specfy = new JMenuItem();
        this.g_shuffle = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.g_shell = new JMenuItem();
        this.g_quick = new JMenuItem();
        this.g_wut = new JMenuItem();
        this.g_ed = new JMenuItem();
        this.g_bubble = new JMenuItem();
        this.g_stooge = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TervisView.this.exec_resize(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        this.menuBar.setName("menuBar");
        ResourceMap resourceMap = Application.getInstance(TervisApp.class).getContext().getResourceMap(TervisView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(TervisApp.class).getContext().getActionMap(TervisView.class, this);
        this.g_speed.setAction(actionMap.get("exec_speed"));
        this.g_speed.setText(resourceMap.getString("g_speed.text", new Object[0]));
        this.g_speed.setName("g_speed");
        fileMenu.add(this.g_speed);
        this.g_specfy.setAction(actionMap.get("exec_specify"));
        this.g_specfy.setText(resourceMap.getString("g_specfy.text", new Object[0]));
        this.g_specfy.setName("g_specfy");
        fileMenu.add(this.g_specfy);
        this.g_shuffle.setAction(actionMap.get("exec_shuffle"));
        this.g_shuffle.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.g_shuffle.setText(resourceMap.getString("g_shuffle.text", new Object[0]));
        this.g_shuffle.setName("g_shuffle");
        fileMenu.add(this.g_shuffle);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        this.g_shell.setAction(actionMap.get("exec_shell"));
        this.g_shell.setText(resourceMap.getString("g_shell.text", new Object[0]));
        this.g_shell.setName("g_shell");
        fileMenu.add(this.g_shell);
        this.g_quick.setAction(actionMap.get("exec_quick"));
        this.g_quick.setText(resourceMap.getString("g_quick.text", new Object[0]));
        this.g_quick.setName("g_quick");
        fileMenu.add(this.g_quick);
        this.g_wut.setAction(actionMap.get("exec_wut"));
        this.g_wut.setText(resourceMap.getString("g_wut.text", new Object[0]));
        this.g_wut.setName("g_wut");
        fileMenu.add(this.g_wut);
        this.g_ed.setAction(actionMap.get("exec_ed"));
        this.g_ed.setText(resourceMap.getString("g_ed.text", new Object[0]));
        this.g_ed.setName("g_ed");
        fileMenu.add(this.g_ed);
        this.g_bubble.setAction(actionMap.get("exec_bubble"));
        this.g_bubble.setText(resourceMap.getString("g_bubble.text", new Object[0]));
        this.g_bubble.setName("g_bubble");
        fileMenu.add(this.g_bubble);
        this.g_stooge.setAction(actionMap.get("exec_stooge"));
        this.g_stooge.setText(resourceMap.getString("g_stooge.text", new Object[0]));
        this.g_stooge.setName("g_stooge");
        fileMenu.add(this.g_stooge);
        this.jSeparator2.setName("jSeparator2");
        fileMenu.add(this.jSeparator2);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    void init() {
        this.items = new int[16];
        this.graph = new Graph(this.mainPanel);
        this.exec_shuffle();
    }

    private void exec_resize(ComponentEvent evt) {
        this.graph.draw(this.items);
    }

    @Action
    public void exec_shuffle() {
        int a;
        ArrayList<Integer> bin = new ArrayList<Integer>();
        for (a = 0; a < this.items.length; ++a) {
            bin.add(a + 1);
        }
        for (a = this.items.length; a > 0; --a) {
            this.items[a - 1] = (Integer)bin.remove(Toolkit.rand(bin.size()));
        }
        this.graph.draw(this.items);
    }

    @Action
    public void exec_specify() {
        try {
            String var = JOptionPane.showInputDialog("Space separated values", (Object)this.itemsToString());
            while (var.contains("  ")) {
                var = var.replace("  ", " ");
            }
            String[] vars = var.trim().split("\\ ");
            this.items = new int[vars.length];
            for (int a = 0; a < vars.length; ++a) {
                this.items[a] = Integer.parseInt(vars[a]);
            }
            this.graph.draw(this.items);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "It is pitch black. You are likely to be eaten by a Grue.");
        }
    }

    private String itemsToString() {
        StringBuilder sbo = new StringBuilder();
        for (int i : this.items) {
            sbo.append(i + " ");
        }
        return sbo.toString();
    }

    @Action
    public void exec_shell() {
        JOptionPane.showMessageDialog(null, "- En av de bedre algoritmene\n- Feilfri visualisering", "Shellsort", 1);
        new SortShell(this.graph, this.items).start();
    }

    @Action
    public void exec_quick() {
        JOptionPane.showMessageDialog(null, "- Generellt sett best\n- Noe glitchy visualisering", "Quicksort", 1);
        new SortQuick(this.graph, this.items).start();
    }

    @Action
    public void exec_wut() {
        JOptionPane.showMessageDialog(null, "- Sammenlikner tilfeldige verdier\n- Feilfri visualisering", "Wutsort", 1);
        new SortWut(this.graph, this.items).start();
    }

    @Action
    public void exec_ed() {
        JOptionPane.showMessageDialog(null, "- O(n\u00b2), eksentrisk fremgangsm\u00e5te\n- Feilfri visualisering", "edSort", 1);
        new SortEd(this.graph, this.items).start();
    }

    @Action
    public void exec_bubble() {
        JOptionPane.showMessageDialog(null, "- Ikke akkurat raskest...\n- Feilfri visualisering", "Bubblesort", 1);
        new SortBubble(this.graph, this.items).start();
    }

    @Action
    public void exec_stooge() {
        JOptionPane.showMessageDialog(null, "- Gammel og elendig.\n- Feilfri visualisering", "Stoogesort", 1);
        new SortStooge(this.graph, this.items).start();
    }

    @Action
    public void exec_speed() {
        JFrame jf = new JFrame("Set speed");
        final JSlider js = new JSlider(1, 500, 500 - this.graph.getDelay());
        js.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TervisView.this.graph.setDelay(500 - js.getValue());
            }
        });
        jf.add(js);
        jf.setSize(320, 96);
        jf.setVisible(true);
    }
}

