/*
 * Decompiled with CFR 0.152.
 */
package tervis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Graph {
    private int delay;
    private final int SLEEP = 200;
    private final int MARGIN_X = 8;
    private final int MARGIN_Y = 24;
    private final double FONTSIZE = 1.5;
    private JComponent p;
    private JButton[] column;
    private JLabel[] hilighter;
    private Color colorDefault;
    private Color colorHilight;
    private int comparisons;
    private int moves;
    private int[] oldHilight;
    private JLabel jStat;

    public Graph(JPanel parent) {
        this.p = parent;
        this.delay = 200;
        this.column = new JButton[0];
        this.comparisons = 0;
        this.moves = 0;
        this.jStat = new JLabel("Hello");
        this.jStat.setSize(200, 32);
        this.jStat.setLocation(8, 8);
        this.jStat.setVerticalAlignment(1);
        this.p.add(this.jStat);
    }

    private void prepare(int columns) {
        int a;
        for (a = 0; a < this.column.length; ++a) {
            this.p.remove(this.hilighter[a]);
            this.p.remove(this.column[a]);
        }
        this.column = new JButton[columns];
        this.hilighter = new JLabel[columns];
        for (a = 0; a < columns; ++a) {
            this.column[a] = new JButton("F");
            this.column[a].setVerticalAlignment(3);
            this.column[a].setHorizontalAlignment(0);
            this.column[a].setBorder(BorderFactory.createRaisedBevelBorder());
            this.p.add(this.column[a]);
            this.hilighter[a] = new JLabel();
            this.hilighter[a].setOpaque(true);
            this.hilighter[a].setVisible(false);
            this.hilighter[a].setBackground(this.hilighter[a].getForeground());
            this.p.add(this.hilighter[a]);
        }
        this.colorDefault = this.column[0].getBackground();
        this.colorHilight = this.column[0].getForeground();
        this.oldHilight = new int[0];
    }

    public void draw(int[] items) {
        if (items.length != this.column.length) {
            this.prepare(items.length);
        }
        int baseWidth = (this.p.getWidth() - 8 * (this.column.length + 1)) / this.column.length;
        int baseHeight = this.p.getHeight() - 48;
        int heightUnit = baseHeight / Math.max(1, this.getMaxVal(items));
        double fontSize = (double)baseWidth / 1.5;
        Font font = new Font("sans-serif", 0, (int)fontSize);
        for (int a = 0; a < items.length; ++a) {
            int itemLeft = (baseWidth + 8) * a + 8;
            int itemHeight = heightUnit * items[a];
            this.column[a].setSize(baseWidth, itemHeight);
            this.column[a].setLocation(itemLeft, this.p.getHeight() - 24 - itemHeight);
            this.column[a].setText(items[a] + "");
            this.column[a].setFont(font);
            this.hilighter[a].setSize(baseWidth, 24);
            this.hilighter[a].setLocation(itemLeft, this.p.getHeight() - 24);
        }
        this.sleep(this.delay);
    }

    public void swap(int ca, int cb) {
        Rectangle ra = this.column[ca].getBounds();
        Rectangle rb = this.column[cb].getBounds();
        int steps = (8 + Math.abs(ca - cb) * 2) / 2;
        int step = (rb.x - ra.x) / steps;
        for (int a = 0; a < steps; ++a) {
            this.column[ca].setLocation(ra.x + a * step, ra.y);
            this.column[cb].setLocation(rb.x + a * -step, rb.y);
            this.sleep(this.delay / 10);
        }
        this.column[ca].setBounds(ra.x, rb.y, ra.width, rb.height);
        this.column[cb].setBounds(rb.x, ra.y, rb.width, ra.height);
        String sa = this.column[ca].getText();
        String sb = this.column[cb].getText();
        this.column[ca].setText(sb);
        this.column[cb].setText(sa);
    }

    private int getMaxVal(int[] items) {
        int ret = 0;
        for (int val : items) {
            ret = Math.max(val, ret);
        }
        return Math.max(1, ret);
    }

    public void hilight(int ... indices) {
        this.hilights(this.delay, indices);
    }

    public void hilights(int delay, int ... indices) {
        for (int indice : this.oldHilight) {
            this.hilighter[indice].setVisible(false);
            this.column[indice].setEnabled(true);
            this.column[indice].setBackground(this.colorDefault);
        }
        for (int indice : indices) {
            this.hilighter[indice].setVisible(true);
            this.column[indice].setEnabled(false);
            this.column[indice].setBackground(this.colorHilight);
        }
        this.oldHilight = indices;
        this.sleep(delay);
    }

    public void extremerice() {
        int[] all = new int[this.column.length];
        for (int a = 0; a < all.length; ++a) {
            all[a] = a;
        }
        this.hilight(all);
        this.hilight(new int[0]);
    }

    private void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.comparisons = 0;
        this.moves = 0;
    }

    public void increase(int cmp, int mov) {
        this.comparisons += cmp;
        this.moves += mov;
        this.jStat.setText("Comparisons / Moves:   " + this.comparisons + " . " + this.moves);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int i) {
        this.delay = i;
    }
}

