/*
 * Decompiled with CFR 0.152.
 */
package oblig02;

import java.util.ArrayList;
import oblig02.Enumerator;
import oblig02.Helper;
import oblig02.Lot;
import oblig02.LotMan;
import oblig02.Mergesort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsBuilder {
    ArrayList<Enumerator> types = new ArrayList();
    ArrayList<Enumerator> owners = new ArrayList();
    ArrayList<Enumerator> ownersc = new ArrayList();
    int lotsTotal = 0;
    int cstrTotal = 0;
    int lotsSold = 0;

    public StatsBuilder() {
    }

    public StatsBuilder(LotMan lot) {
        this();
        this.add(lot.getLots());
        this.order();
    }

    public void add(Lot[][] lot) {
        for (int y = 0; y < lot.length; ++y) {
            for (int x = 0; x < lot[y].length; ++x) {
                if (lot[y][x] != null) {
                    this.add(lot[y][x]);
                    ++this.lotsSold;
                }
                ++this.lotsTotal;
            }
        }
    }

    public void add(Lot lot) {
        this.add(this.types, lot.type);
        this.add(this.owners, lot.owner);
        if (lot.type.length() > 0) {
            this.add(this.ownersc, lot.owner);
            ++this.cstrTotal;
        }
    }

    void add(ArrayList<Enumerator> alenum, String value) {
        this.add(alenum, value, 1);
    }

    void add(ArrayList<Enumerator> alenum, String value, int count) {
        if (value.length() == 0) {
            return;
        }
        for (int a = 0; a < alenum.size(); ++a) {
            if (!alenum.get(a).matches(value)) continue;
            alenum.get(a).inc(count);
            return;
        }
        alenum.add(new Enumerator(value, count));
    }

    public void order() {
        this.ownersc = Mergesort.sort(this.ownersc);
        this.owners = Mergesort.sort(this.owners);
        this.types = Mergesort.sort(this.types);
    }

    Enumerator[] getEnumerator(ArrayList<Enumerator> alenu) {
        Object[] ret = new Enumerator[alenu.size()];
        for (int a = 0; a < ret.length; ++a) {
            ret[a] = alenu.get(a);
        }
        Helper.flipArray(ret);
        return ret;
    }

    public int getLotsTotal() {
        return this.lotsTotal;
    }

    public int getCstrTotal() {
        return this.cstrTotal;
    }

    public int getLotsSold() {
        return this.lotsSold;
    }

    public Enumerator[] getOwners() {
        return this.getEnumerator(this.owners);
    }

    public Enumerator[] getOwnersWithCstr() {
        return this.getEnumerator(this.ownersc);
    }

    public Enumerator[] getTypes() {
        return this.getEnumerator(this.types);
    }

    static double getPerc(double val, double max) {
        double ret = val * 100.0 / max;
        return (double)Math.round(ret * 10.0) / 10.0;
    }

    public double getSoldPerc() {
        return StatsBuilder.getPerc(this.lotsSold, this.lotsTotal);
    }

    public double getCstrPerLotPerc() {
        return StatsBuilder.getPerc(this.cstrTotal, this.lotsTotal);
    }

    public double getCstrPerOwnerPerc() {
        return StatsBuilder.getPerc(this.cstrTotal, this.lotsSold);
    }
}

