/*
 * Decompiled with CFR 0.152.
 */
package oblig02;

import oblig02.Enumerator;
import oblig02.Helper;
import oblig02.IO;
import oblig02.LotMan;
import oblig02.StatsBuilder;

public class Main {
    static IO io;
    static LotMan mlot;
    static Helper h;

    public static void main(String[] args) {
        io = new IO();
        mlot = io.getb("Load last database", true) ? new LotMan(13, 11, "oblig02.db") : new LotMan(13, 11);
        h = new Helper(mlot, io);
        io.put();
        boolean GTFO = false;
        while (!GTFO) {
            io.put(io.colour(4) + "-=+> KINGSHILL LOTSALE <+=-");
            io.put(io.colour(-1));
            io.put("You may pick amongst the following.");
            io.put();
            io.put("  1) Buy lot");
            io.put("  2) List data");
            io.put("  3) Draw map");
            io.put("  4) New house");
            io.put("  5) Statistics");
            io.put("  6) Quit");
            io.put();
            int opt = io.get("Choose wisely", 1, 6);
            if (opt == 1) {
                Main.buyLot(new int[0], true);
            }
            if (opt == 2) {
                Main.listData();
            }
            if (opt == 3) {
                io.put(mlot.drawMap(io, true));
                io.get();
                io.put(mlot.drawMap(io, false));
            }
            if (opt == 4) {
                Main.newHouse(new int[0]);
            }
            if (opt == 5) {
                Main.getStats();
            }
            if (opt == 6 && (mlot.Save("oblig02.db") || io.getb("Unable to save! Continue anyhow", false))) {
                GTFO = true;
            }
            io.put();
        }
    }

    static void buyLot(int[] ptr, boolean queryBuyNext) {
        int y;
        int x;
        if (ptr.length == 0) {
            ptr = h.requestLot();
        }
        boolean hasOwner = !mlot.isAvailable(x = ptr[0], y = ptr[1]);
        String owner = h.requestName(true);
        if (hasOwner && owner.equalsIgnoreCase(mlot.getOwner(x, y))) {
            io.throwError("\u201c" + mlot.getOwner(x, y) + "\u201d is " + "already enlisted as the owner of this lot!");
            return;
        }
        if (hasOwner && !io.getb("This lot's the property of \u201c" + mlot.getOwner(x, y) + "\u201d. Are you sure you wish to change owner", true)) {
            return;
        }
        if (!mlot.hasOwnerLike(owner) && !io.getb("New owner... Continue", true)) {
            return;
        }
        mlot.setOwner(x, y, owner);
        io.put("Company \u201c" + owner + "\u201d is now the proud " + "owner of lot " + x + "-" + y + " :D");
        if (queryBuyNext && (ptr = h.checkBuyNext(x, y)).length > 0) {
            Main.buyLot(ptr, true);
        }
    }

    static void listData() {
        int[] bounds = mlot.getBounds();
        int bx = bounds[0];
        int by = bounds[1];
        int totalLots = 0;
        int totalBought = 0;
        int totalConstructions = 0;
        for (int y = 0; y < by; ++y) {
            for (int x = 0; x < bx; ++x) {
                ++totalLots;
                if (mlot.isAvailable(x, y)) continue;
                ++totalBought;
                String type = mlot.getType(x, y);
                String owner = mlot.getOwner(x, y);
                io.puts("Lot " + x + "-" + y + " is the " + "property of \u201c" + owner + "\u201d. ");
                if (type.length() > 0) {
                    ++totalConstructions;
                    io.put("There's a " + type + " located here.");
                    continue;
                }
                io.put("There are no constructions on this lot.");
            }
        }
        System.out.println("In total, there are " + totalLots + " lots of which " + totalBought + " have been bought. " + "Also, there are " + totalConstructions + " constructions.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void newHouse(int[] ptr) {
        int y;
        int x;
        if (ptr.length == 0) {
            ptr = h.requestLot();
        }
        if (mlot.isAvailable(x = ptr[0], y = ptr[1])) {
            if (!io.getb("This lot hasn't been bought yet. Buy now", true)) return;
            Main.buyLot(ptr, false);
            io.put();
        } else {
            io.put("FYI, the owner of this lot is \u201c" + mlot.getOwner(x, y) + "\u201d.");
        }
        String type = h.requestName(false);
        mlot.setType(x, y, type);
        io.put("DUE TO SOME UNEXPLAINABLE FANTASTIC SCIENCE, THIS LOT NOW HAS A " + type + ".");
        ptr = h.checkBuyNext(x, y);
        if (ptr.length <= 0) return;
        Main.newHouse(ptr);
    }

    static void getStats() {
        StatsBuilder stats = new StatsBuilder(mlot);
        Enumerator[] constr = stats.getTypes();
        io.put("All housetypes (" + constr.length + "), sorted by popularity:");
        h.dumpEnumerator(constr);
        Enumerator[] company = stats.getOwners();
        io.put("All companies (" + company.length + "), sorted by lot count:");
        h.dumpEnumerator(company);
        Enumerator[] companyc = stats.getOwnersWithCstr();
        io.put("All companies (" + companyc.length + "), sorted by house count:");
        h.dumpEnumerator(companyc);
        io.put("In total, there are " + stats.getLotsTotal() + " lots on our premises.");
        io.put("Out of these, " + stats.getLotsSold() + " have been sold. That's " + stats.getSoldPerc() + "%.");
        io.put("Out of these, " + stats.getCstrTotal() + " have " + "constructions. That's " + stats.getCstrPerOwnerPerc() + "%.");
        io.put("In total, " + stats.getCstrPerLotPerc() + "% of all lots have a construction of sorts.");
    }
}

