/*
 * Decompiled with CFR 0.152.
 */
package oblig02;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import oblig02.Enumerator;
import oblig02.IO;
import oblig02.Lot;
import oblig02.StatsBuilder;

public class LotMan {
    Lot[][] lot;

    public LotMan(int x, int y) {
        this.lot = new Lot[y][x];
    }

    public LotMan(int x, int y, String filename) {
        this(x, y);
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            int[] sz = LotMan.parsePtr(br.readLine());
            this.lot = new Lot[sz[1]][sz[0]];
            while (true) {
                int[] ptr = LotMan.parsePtr(br.readLine());
                this.setOwner(ptr[0], ptr[1], br.readLine());
                this.setType(ptr[0], ptr[1], br.readLine());
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    public int[] getBounds() {
        return new int[]{this.lot[0].length, this.lot.length};
    }

    public boolean Save(String filename) {
        try {
            FileWriter fw = new FileWriter(filename);
            BufferedWriter bw = new BufferedWriter(fw);
            int[] sz = this.getBounds();
            bw.write(sz[0] + "." + sz[1] + "\n");
            for (int y = 0; y < sz[1]; ++y) {
                for (int x = 0; x < sz[0]; ++x) {
                    if (this.isAvailable(x, y)) continue;
                    bw.write(x + "." + y + "\n");
                    bw.write(this.getOwner(x, y) + "\n");
                    bw.write(this.getType(x, y) + "\n");
                }
            }
            bw.flush();
            fw.flush();
            fw.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Lot[][] getLots() {
        return this.lot;
    }

    static int[] parsePtr(String ptrs) {
        int ofs = -1;
        for (int a = 0; a < ptrs.length(); ++a) {
            char ch = ptrs.charAt(a);
            if (ch >= '0' && ch <= '9') continue;
            ofs = a;
        }
        try {
            return new int[]{Integer.parseInt(ptrs.substring(0, ofs)), Integer.parseInt(ptrs.substring(ofs + 1))};
        }
        catch (Exception ex) {
            return new int[0];
        }
    }

    boolean validPtr(int x, int y) {
        return y < this.lot.length && x < this.lot[0].length;
    }

    boolean isAvailable(int x, int y) {
        if (this.validPtr(x, y)) {
            return this.lot[y][x] == null;
        }
        return false;
    }

    boolean setOwner(int x, int y, String owner) {
        if (this.validPtr(x, y)) {
            this.lot[y][x] = new Lot(owner);
            return true;
        }
        return false;
    }

    boolean setType(int x, int y, String type) {
        if (!this.isAvailable(x, y)) {
            this.lot[y][x].type = type;
            return true;
        }
        return false;
    }

    String drawMap(IO io, boolean companies) {
        int a;
        StatsBuilder stats = new StatsBuilder(this);
        Enumerator[] legend = null;
        legend = companies ? stats.getOwners() : stats.getTypes();
        StringBuilder ret = new StringBuilder();
        ret.append("   ");
        int[] bounds = this.getBounds();
        for (a = 0; a < bounds[0]; ++a) {
            ret.append(String.format("%3d", a));
        }
        ret.append("\n");
        for (int y = 0; y < bounds[1]; ++y) {
            ret.append(String.format("%3d", y));
            for (int x = 0; x < bounds[0]; ++x) {
                char append = '.';
                if (!this.isAvailable(x, y)) {
                    for (int a2 = 0; a2 < legend.length; ++a2) {
                        if (companies) {
                            if (!legend[a2].matches(this.lot[y][x].owner)) continue;
                            append = (char)(97 + a2);
                            continue;
                        }
                        if (!legend[a2].matches(this.lot[y][x].type)) continue;
                        append = (char)(97 + a2);
                    }
                    if (this.lot[y][x].type.length() > 0) {
                        append = (char)(append - 32);
                    }
                }
                if (append == '.') {
                    ret.append(io.colour(5));
                } else if (append >= 'a' && append <= 'z') {
                    ret.append(io.colour(1));
                } else if (append >= 'A' && append <= 'Z') {
                    ret.append(io.colour(2));
                }
                ret.append(String.format("%3s", Character.valueOf(append)));
            }
            ret.append(io.colour(-1) + "\n");
        }
        for (a = 0; a < legend.length; ++a) {
            ret.append("  " + (char)(97 + a) + ") " + legend[a].name + "\n");
        }
        return ret.toString();
    }

    int[][] getBy(String owner, String type) {
        int[] bounds = this.getBounds();
        ArrayList<int[]> ret = new ArrayList<int[]>();
        for (int y = 0; y < this.lot.length; ++y) {
            for (int x = 0; x < this.lot[y].length; ++x) {
                if (this.lot[y][x] == null) continue;
                if (owner.length() == 0) {
                    if (!type.equalsIgnoreCase(this.lot[y][x].type)) continue;
                    ret.add(new int[]{x, y});
                    continue;
                }
                if (!owner.equalsIgnoreCase(this.lot[y][x].owner)) continue;
                ret.add(new int[]{x, y});
            }
        }
        int[][] retf = new int[ret.size()][];
        for (int a = 0; a < retf.length; ++a) {
            retf[a] = (int[])ret.get(a);
        }
        return retf;
    }

    int[][] getByType(String type) {
        return this.getBy("", type);
    }

    int[][] getByOwner(String owner) {
        return this.getBy(owner, "");
    }

    String getOwner(int x, int y) {
        if (this.validPtr(x, y) && !this.isAvailable(x, y)) {
            return this.lot[y][x].owner;
        }
        return "";
    }

    String getType(int x, int y) {
        if (this.validPtr(x, y) && !this.isAvailable(x, y)) {
            return this.lot[y][x].type;
        }
        return "";
    }

    boolean hasOwnerLike(String owner) {
        int[] bounds = this.getBounds();
        for (int y = 0; y < bounds[1]; ++y) {
            for (int x = 0; x < bounds[0]; ++x) {
                if (this.isAvailable(x, y) || !this.lot[y][x].owner.equalsIgnoreCase(owner)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasTypeLike(String type) {
        int[] bounds = this.getBounds();
        for (int y = 0; y < bounds[1]; ++y) {
            for (int x = 0; x < bounds[0]; ++x) {
                if (this.isAvailable(x, y) || !this.lot[y][x].type.equalsIgnoreCase(type)) continue;
                return true;
            }
        }
        return false;
    }
}

