# Maintainer Collaboration Guidelines

## Ownership Boundaries
Core ownership includes final authority on major project direction, branding, external representation (e.g., website, GitHub org settings), and financial decisions. Project leadership roles should support this structure, not compete with it.  
Joshua Granick remains the primary owner of OpenFL and related projects under its umbrella, including all copyrights, branding, and rights to external representations.

## Commit Transparency
All commits — especially those involving the website or project structure — should be clearly described. Avoid vague or misleading commit messages.

## No Unilateral Decisions
Significant changes to the public-facing site, GitHub structure, or future policies (including donation links) must be discussed with the core team before being merged.  
High contribution volume does not entitle anyone to override team consensus or operate outside the established process. We value impact, but we expect humility and collaboration in return.

## Respect Other Maintainers’ Work
Reverting, overwriting, or contradicting another maintainer’s contribution must go through discussion first — ideally via PR, not direct commit.

## Escalation Policy
If collaboration issues persist after a discussion, core owners may revoke elevated roles or privileges to protect the health of the project. This isn’t personal — it’s structural.

## Donations & Monetization
Any personal monetization links (Patreon, Ko-fi, etc.) require approval by the core **owners**. We want to keep funding equitable and transparent.

## Communication First
If you disagree with a decision or direction, bring it up in team chat or discussion threads — not by taking action in silence.

## We Are a Team
Leadership means contributing to both the codebase and the culture. If you’re not supporting both, you’re not fulfilling the role.
