/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.DEVMODE;
import org.lwjgl.system.windows.EnumObjectsProc;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.POINT;

public final class WinGDI {
    public static final int DM_DISPLAYORIENTATION = 128;
    public static final int DM_LOGPIXELS = 131072;
    public static final int DM_BITSPERPEL = 262144;
    public static final int DM_PELSWIDTH = 524288;
    public static final int DM_PELSHEIGHT = 0x100000;
    public static final int DM_DISPLAYFLAGS = 0x200000;
    public static final int DM_DISPLAYFREQUENCY = 0x400000;
    public static final int DM_DISPLAYFIXEDOUTPUT = 0x20000000;
    public static final int WHITE_BRUSH = 0;
    public static final int LTGRAY_BRUSH = 1;
    public static final int GRAY_BRUSH = 2;
    public static final int DKGRAY_BRUSH = 3;
    public static final int BLACK_BRUSH = 4;
    public static final int NULL_BRUSH = 5;
    public static final int HOLLOW_BRUSH = 5;
    public static final int WHITE_PEN = 6;
    public static final int BLACK_PEN = 7;
    public static final int NULL_PEN = 8;
    public static final int OEM_FIXED_FONT = 10;
    public static final int ANSI_FIXED_FONT = 11;
    public static final int ANSI_VAR_FONT = 12;
    public static final int SYSTEM_FONT = 13;
    public static final int DEVICE_DEFAULT_FONT = 14;
    public static final int DEFAULT_PALETTE = 15;
    public static final int SYSTEM_FIXED_FONT = 16;
    public static final int DEFAULT_GUI_FONT = 17;
    public static final int DC_BRUSH = 18;
    public static final int DC_PEN = 19;
    public static final int OBJ_PEN = 1;
    public static final int OBJ_BRUSH = 2;
    public static final int OBJ_DC = 3;
    public static final int OBJ_METADC = 4;
    public static final int OBJ_PAL = 5;
    public static final int OBJ_FONT = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;
    public static final int OBJ_METAFILE = 9;
    public static final int OBJ_MEMDC = 10;
    public static final int OBJ_EXTPEN = 11;
    public static final int OBJ_ENHMETADC = 12;
    public static final int OBJ_ENHMETAFILE = 13;
    public static final int OBJ_COLORSPACE = 14;
    public static final int DRIVERVERSION = 0;
    public static final int TECHNOLOGY = 2;
    public static final int HORZSIZE = 4;
    public static final int VERTSIZE = 6;
    public static final int HORZRES = 8;
    public static final int VERTRES = 10;
    public static final int BITSPIXEL = 12;
    public static final int PLANES = 14;
    public static final int NUMBRUSHES = 16;
    public static final int NUMPENS = 18;
    public static final int NUMMARKERS = 20;
    public static final int NUMFONTS = 22;
    public static final int NUMCOLORS = 24;
    public static final int PDEVICESIZE = 26;
    public static final int CURVECAPS = 28;
    public static final int LINECAPS = 30;
    public static final int POLYGONALCAPS = 32;
    public static final int TEXTCAPS = 34;
    public static final int CLIPCAPS = 36;
    public static final int RASTERCAPS = 38;
    public static final int ASPECTX = 40;
    public static final int ASPECTY = 42;
    public static final int ASPECTXY = 44;
    public static final int LOGPIXELSX = 88;
    public static final int LOGPIXELSY = 90;
    public static final int SIZEPALETTE = 104;
    public static final int NUMRESERVED = 106;
    public static final int COLORRES = 108;
    public static final int VREFRESH = 116;
    public static final int DESKTOPVERTRES = 117;
    public static final int DESKTOPHORZRES = 118;
    public static final int BLTALIGNMENT = 119;
    public static final int SHADEBLENDCAPS = 120;
    public static final int COLORMGMTCAPS = 121;
    public static final int PFD_DOUBLEBUFFER = 1;
    public static final int PFD_STEREO = 2;
    public static final int PFD_DRAW_TO_WINDOW = 4;
    public static final int PFD_DRAW_TO_BITMAP = 8;
    public static final int PFD_SUPPORT_GDI = 16;
    public static final int PFD_SUPPORT_OPENGL = 32;
    public static final int PFD_GENERIC_FORMAT = 64;
    public static final int PFD_NEED_PALETTE = 128;
    public static final int PFD_NEED_SYSTEM_PALETTE = 256;
    public static final int PFD_SWAP_EXCHANGE = 512;
    public static final int PFD_SWAP_COPY = 1024;
    public static final int PFD_SWAP_LAYER_BUFFERS = 2048;
    public static final int PFD_GENERIC_ACCELERATED = 4096;
    public static final int PFD_SUPPORT_DIRECTDRAW = 8192;
    public static final int PFD_DIRECT3D_ACCELERATED = 16384;
    public static final int PFD_SUPPORT_COMPOSITION = 32768;
    public static final int PFD_DEPTH_DONTCARE = 0x20000000;
    public static final int PFD_DOUBLEBUFFER_DONTCARE = 0x40000000;
    public static final int PFD_STEREO_DONTCARE = Integer.MIN_VALUE;
    public static final int PFD_TYPE_RGBA = 0;
    public static final int PFD_TYPE_COLORINDEX = 1;
    public static final int PFD_MAIN_PLANE = 0;
    public static final int PFD_OVERLAY_PLANE = 1;
    public static final int PFD_UNDERLAY_PLANE = -1;

    private WinGDI() {
    }

    public static native long GetStockObject(int var0);

    public static native int nEnumObjects(long var0, int var2, long var3, long var5);

    public static int EnumObjects(long hdc, int objectType, long objectFunc, long param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nEnumObjects(hdc, objectType, objectFunc, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int EnumObjects(long hdc, int objectType, EnumObjectsProc objectFunc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        long param = MemoryUtil.memGlobalRefNew(objectFunc);
        try {
            int n = WinGDI.nEnumObjects(hdc, objectType, EnumObjectsProc.Util.CALLBACK, param);
            return n;
        }
        finally {
            MemoryUtil.memGlobalRefDelete(param);
        }
    }

    public static native long nSelectObject(long var0, long var2);

    public static long SelectObject(long hdc, long object) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkPointer(object);
        }
        return WinGDI.nSelectObject(hdc, object);
    }

    public static native long nGetCurrentObject(long var0, int var2);

    public static long GetCurrentObject(long hdc, int objectType) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nGetCurrentObject(hdc, objectType);
    }

    public static native int nGetObjectType(long var0);

    public static int GetObjectType(long object) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(object);
        }
        return WinGDI.nGetObjectType(object);
    }

    public static native int nDeleteObject(long var0);

    public static int DeleteObject(long object) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(object);
        }
        return WinGDI.nDeleteObject(object);
    }

    public static native long nCreateDC(long var0, long var2, long var4, long var6);

    public static long CreateDC(ByteBuffer lpszDriver, ByteBuffer lpszDevice, ByteBuffer lpszOutput, ByteBuffer lpInitData) {
        if (LWJGLUtil.CHECKS) {
            if (lpszDriver != null) {
                Checks.checkNT2(lpszDriver);
            }
            if (lpszDevice != null) {
                Checks.checkNT2(lpszDevice);
            }
            if (lpInitData != null) {
                Checks.checkBuffer((Buffer)lpInitData, DEVMODE.SIZEOF);
            }
        }
        return WinGDI.nCreateDC(MemoryUtil.memAddressSafe(lpszDriver), MemoryUtil.memAddressSafe(lpszDevice), MemoryUtil.memAddressSafe(lpszOutput), MemoryUtil.memAddressSafe(lpInitData));
    }

    public static long CreateDC(CharSequence lpszDriver, CharSequence lpszDevice, CharSequence lpszOutput, ByteBuffer lpInitData) {
        if (LWJGLUtil.CHECKS && lpInitData != null) {
            Checks.checkBuffer((Buffer)lpInitData, DEVMODE.SIZEOF);
        }
        ByteBuffer lpszDriverEncoded = MemoryUtil.memEncodeUTF16(lpszDriver);
        ByteBuffer lpszDeviceEncoded = MemoryUtil.memEncodeUTF16(lpszDevice);
        ByteBuffer lpszOutputEncoded = MemoryUtil.memEncodeUTF16(lpszOutput);
        return WinGDI.nCreateDC(MemoryUtil.memAddressSafe(lpszDriverEncoded), MemoryUtil.memAddressSafe(lpszDeviceEncoded), MemoryUtil.memAddressSafe(lpszOutputEncoded), MemoryUtil.memAddressSafe(lpInitData));
    }

    public static native long nCreateCompatibleDC(long var0);

    public static long CreateCompatibleDC(long hdc) {
        return WinGDI.nCreateCompatibleDC(hdc);
    }

    public static native int nDeleteDC(long var0);

    public static int DeleteDC(long hdc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nDeleteDC(hdc);
    }

    public static native int nCancelDC(long var0);

    public static int CancelDC(long hdc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nCancelDC(hdc);
    }

    public static native int nSaveDC(long var0);

    public static int SaveDC(long hdc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nSaveDC(hdc);
    }

    public static native int nRestoreDC(long var0, int var2);

    public static int RestoreDC(long hdc, int savedDC) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nRestoreDC(hdc, savedDC);
    }

    public static native int nGetDCOrgEx(long var0, long var2);

    public static int GetDCOrgEx(long hdc, ByteBuffer point) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkBuffer((Buffer)point, POINT.SIZEOF);
        }
        return WinGDI.nGetDCOrgEx(hdc, MemoryUtil.memAddress(point));
    }

    public static native int nGetDeviceCaps(long var0, int var2);

    public static int GetDeviceCaps(long hdc, int index) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nGetDeviceCaps(hdc, index);
    }

    public static native int nGetDeviceGammaRamp(long var0, long var2);

    public static int GetDeviceGammaRamp(long hdc, long lpRamp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkPointer(lpRamp);
        }
        return WinGDI.nGetDeviceGammaRamp(hdc, lpRamp);
    }

    public static native int nSetDeviceGammaRamp(long var0, long var2);

    public static int SetDeviceGammaRamp(long hdc, long lpRamp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkPointer(lpRamp);
        }
        return WinGDI.nSetDeviceGammaRamp(hdc, lpRamp);
    }

    public static native int nChoosePixelFormat(long var0, long var2);

    public static int ChoosePixelFormat(long hdc, ByteBuffer pixelFormatDescriptor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkBuffer((Buffer)pixelFormatDescriptor, PIXELFORMATDESCRIPTOR.SIZEOF);
        }
        return WinGDI.nChoosePixelFormat(hdc, MemoryUtil.memAddress(pixelFormatDescriptor));
    }

    public static native int nDescribePixelFormat(long var0, int var2, int var3, long var4);

    public static int DescribePixelFormat(long hdc, int pixelFormat, int bytes, ByteBuffer pixelFormatDescriptor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            if (pixelFormatDescriptor != null) {
                Checks.checkBuffer((Buffer)pixelFormatDescriptor, PIXELFORMATDESCRIPTOR.SIZEOF);
            }
        }
        return WinGDI.nDescribePixelFormat(hdc, pixelFormat, bytes, MemoryUtil.memAddressSafe(pixelFormatDescriptor));
    }

    public static int DescribePixelFormat(long hdc, int pixelFormat, ByteBuffer pixelFormatDescriptor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            if (pixelFormatDescriptor != null) {
                Checks.checkBuffer((Buffer)pixelFormatDescriptor, PIXELFORMATDESCRIPTOR.SIZEOF);
            }
        }
        return WinGDI.nDescribePixelFormat(hdc, pixelFormat, PIXELFORMATDESCRIPTOR.SIZEOF, MemoryUtil.memAddressSafe(pixelFormatDescriptor));
    }

    public static native int nGetPixelFormat(long var0);

    public static int GetPixelFormat(long hdc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WinGDI.nGetPixelFormat(hdc);
    }

    public static native int nSetPixelFormat(long var0, int var2, long var3);

    public static int SetPixelFormat(long hdc, int pixelFormat, ByteBuffer pixelFormatDescriptor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkBuffer((Buffer)pixelFormatDescriptor, PIXELFORMATDESCRIPTOR.SIZEOF);
        }
        return WinGDI.nSetPixelFormat(hdc, pixelFormat, MemoryUtil.memAddress(pixelFormatDescriptor));
    }

    public static native int nSwapBuffers(long var0);

    public static int SwapBuffers(long dc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(dc);
        }
        return WinGDI.nSwapBuffers(dc);
    }

    static {
        Sys.touch();
    }
}

