/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.LARGE_INTEGER;
import org.lwjgl.system.windows.OSVERSIONINFOEX;

public final class WinBase {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int GMEM_FIXED = 0;
    public static final int GMEM_MOVEABLE = 2;
    public static final int GMEM_NOCOMPACT = 16;
    public static final int GMEM_NODISCARD = 32;
    public static final int GMEM_ZEROINIT = 64;
    public static final int GMEM_MODIFY = 128;
    public static final int GMEM_DISCARDABLE = 256;
    public static final int GMEM_NOT_BANKED = 4096;
    public static final int GMEM_SHARE = 8192;
    public static final int GMEM_DDESHARE = 8192;
    public static final int GMEM_NOTIFY = 16384;
    public static final int GMEM_LOWER = 4096;
    public static final int GMEM_VALID_FLAGS = 32626;
    public static final int GMEM_INVALID_HANDLE = 32768;
    public static final int GHND = 66;
    public static final int GPTR = 64;

    private WinBase() {
    }

    public static native int nGetVersionEx(long var0);

    public static int GetVersionEx(ByteBuffer versionInfo) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)versionInfo, OSVERSIONINFOEX.SIZEOF);
        }
        return WinBase.nGetVersionEx(MemoryUtil.memAddress(versionInfo));
    }

    public static native int GetLastError();

    public static native long nGetModuleHandle(long var0);

    public static long GetModuleHandle(ByteBuffer moduleName) {
        if (LWJGLUtil.CHECKS && moduleName != null) {
            Checks.checkNT2(moduleName);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleName));
    }

    public static long GetModuleHandle(CharSequence moduleName) {
        ByteBuffer moduleNameEncoded = MemoryUtil.memEncodeUTF16(moduleName);
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleNameEncoded));
    }

    public static native long nLoadLibrary(long var0);

    public static long LoadLibrary(ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(name);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(name));
    }

    public static long LoadLibrary(CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeUTF16(name);
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(nameEncoded));
    }

    public static native long nGetProcAddress(long var0, long var2);

    public static long GetProcAddress(long handle, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
            Checks.checkNT1(name);
        }
        return WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(name));
    }

    public static long GetProcAddress(long handle, CharSequence name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
        }
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(nameEncoded));
    }

    public static native int nFreeLibrary(long var0);

    public static int FreeLibrary(long handle) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
        }
        return WinBase.nFreeLibrary(handle);
    }

    public static native int nQueryPerformanceFrequency(long var0);

    public static int QueryPerformanceFrequency(ByteBuffer frequency) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)frequency, LARGE_INTEGER.SIZEOF);
        }
        return WinBase.nQueryPerformanceFrequency(MemoryUtil.memAddress(frequency));
    }

    public static native int nQueryPerformanceCounter(long var0);

    public static int QueryPerformanceCounter(ByteBuffer frequency) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)frequency, LARGE_INTEGER.SIZEOF);
        }
        return WinBase.nQueryPerformanceCounter(MemoryUtil.memAddress(frequency));
    }

    public static native long GlobalAlloc(int var0, long var1);

    public static native long nGlobalLock(long var0);

    public static long GlobalLock(long hMem) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hMem);
        }
        return WinBase.nGlobalLock(hMem);
    }

    public static native int nGlobalUnlock(long var0);

    public static int GlobalUnlock(long hMem) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hMem);
        }
        return WinBase.nGlobalUnlock(hMem);
    }

    public static native long nGlobalFree(long var0);

    public static long GlobalFree(long hMem) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hMem);
        }
        return WinBase.nGlobalFree(hMem);
    }

    static {
        Sys.touch();
    }
}

