/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class WNDCLASSEX {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int STYLE;
    public static final int WNDPROC;
    public static final int CLSEXTRA;
    public static final int WNDEXTRA;
    public static final int INSTANCE;
    public static final int ICON;
    public static final int CURSOR;
    public static final int BACKGROUND;
    public static final int MENUNAME;
    public static final int CLASSNAME;
    public static final int ICONSM;

    private WNDCLASSEX() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int size, int style, long wndProc, int clsExtra, int wndExtra, long instance, long icon, long cursor, long background, long menuName, long className, long iconSm) {
        ByteBuffer wndclassex = WNDCLASSEX.malloc();
        WNDCLASSEX.size(wndclassex, size);
        WNDCLASSEX.style(wndclassex, style);
        WNDCLASSEX.wndProc(wndclassex, wndProc);
        WNDCLASSEX.clsExtra(wndclassex, clsExtra);
        WNDCLASSEX.wndExtra(wndclassex, wndExtra);
        WNDCLASSEX.instance(wndclassex, instance);
        WNDCLASSEX.icon(wndclassex, icon);
        WNDCLASSEX.cursor(wndclassex, cursor);
        WNDCLASSEX.background(wndclassex, background);
        WNDCLASSEX.menuName(wndclassex, menuName);
        WNDCLASSEX.className(wndclassex, className);
        WNDCLASSEX.iconSm(wndclassex, iconSm);
        return wndclassex;
    }

    public static ByteBuffer malloc(int size, int style, long wndProc, int clsExtra, int wndExtra, long instance, long icon, long cursor, long background, ByteBuffer menuName, ByteBuffer className, long iconSm) {
        ByteBuffer wndclassex = WNDCLASSEX.malloc();
        WNDCLASSEX.size(wndclassex, size);
        WNDCLASSEX.style(wndclassex, style);
        WNDCLASSEX.wndProc(wndclassex, wndProc);
        WNDCLASSEX.clsExtra(wndclassex, clsExtra);
        WNDCLASSEX.wndExtra(wndclassex, wndExtra);
        WNDCLASSEX.instance(wndclassex, instance);
        WNDCLASSEX.icon(wndclassex, icon);
        WNDCLASSEX.cursor(wndclassex, cursor);
        WNDCLASSEX.background(wndclassex, background);
        WNDCLASSEX.menuNameSet(wndclassex, menuName);
        WNDCLASSEX.classNameSet(wndclassex, className);
        WNDCLASSEX.iconSm(wndclassex, iconSm);
        return wndclassex;
    }

    public static ByteBuffer malloc(int size, int style, long wndProc, int clsExtra, int wndExtra, long instance, long icon, long cursor, long background, CharSequence menuName, CharSequence className, long iconSm) {
        ByteBuffer wndclassex = WNDCLASSEX.malloc();
        WNDCLASSEX.size(wndclassex, size);
        WNDCLASSEX.style(wndclassex, style);
        WNDCLASSEX.wndProc(wndclassex, wndProc);
        WNDCLASSEX.clsExtra(wndclassex, clsExtra);
        WNDCLASSEX.wndExtra(wndclassex, wndExtra);
        WNDCLASSEX.instance(wndclassex, instance);
        WNDCLASSEX.icon(wndclassex, icon);
        WNDCLASSEX.cursor(wndclassex, cursor);
        WNDCLASSEX.background(wndclassex, background);
        WNDCLASSEX.menuNameSet(wndclassex, menuName);
        WNDCLASSEX.classNameSet(wndclassex, className);
        WNDCLASSEX.iconSm(wndclassex, iconSm);
        return wndclassex;
    }

    public static void size(ByteBuffer wndclassex, int size) {
        wndclassex.putInt(wndclassex.position() + SIZE, size);
    }

    public static void style(ByteBuffer wndclassex, int style) {
        wndclassex.putInt(wndclassex.position() + STYLE, style);
    }

    public static void wndProc(ByteBuffer wndclassex, long wndProc) {
        PointerBuffer.put(wndclassex, wndclassex.position() + WNDPROC, wndProc);
    }

    public static void clsExtra(ByteBuffer wndclassex, int clsExtra) {
        wndclassex.putInt(wndclassex.position() + CLSEXTRA, clsExtra);
    }

    public static void wndExtra(ByteBuffer wndclassex, int wndExtra) {
        wndclassex.putInt(wndclassex.position() + WNDEXTRA, wndExtra);
    }

    public static void instance(ByteBuffer wndclassex, long instance) {
        PointerBuffer.put(wndclassex, wndclassex.position() + INSTANCE, instance);
    }

    public static void icon(ByteBuffer wndclassex, long icon) {
        PointerBuffer.put(wndclassex, wndclassex.position() + ICON, icon);
    }

    public static void cursor(ByteBuffer wndclassex, long cursor) {
        PointerBuffer.put(wndclassex, wndclassex.position() + CURSOR, cursor);
    }

    public static void background(ByteBuffer wndclassex, long background) {
        PointerBuffer.put(wndclassex, wndclassex.position() + BACKGROUND, background);
    }

    public static void menuName(ByteBuffer wndclassex, long menuName) {
        PointerBuffer.put(wndclassex, wndclassex.position() + MENUNAME, menuName);
    }

    public static void menuNameSet(ByteBuffer wndclassex, ByteBuffer menuName) {
        WNDCLASSEX.menuName(wndclassex, menuName == null ? 0L : MemoryUtil.memAddress(Checks.checkNT2(menuName)));
    }

    public static void menuNameSet(ByteBuffer wndclassex, CharSequence menuName) {
        long l;
        if (menuName == null) {
            l = 0L;
        } else {
            ByteBuffer menuNameEncoded = MemoryUtil.memEncodeUTF16(menuName);
            l = MemoryUtil.memAddress(menuNameEncoded);
        }
        WNDCLASSEX.menuName(wndclassex, l);
    }

    public static void className(ByteBuffer wndclassex, long className) {
        PointerBuffer.put(wndclassex, wndclassex.position() + CLASSNAME, className);
    }

    public static void classNameSet(ByteBuffer wndclassex, ByteBuffer className) {
        WNDCLASSEX.className(wndclassex, className == null ? 0L : MemoryUtil.memAddress(Checks.checkNT2(className)));
    }

    public static void classNameSet(ByteBuffer wndclassex, CharSequence className) {
        long l;
        if (className == null) {
            l = 0L;
        } else {
            ByteBuffer classNameEncoded = MemoryUtil.memEncodeUTF16(className);
            l = MemoryUtil.memAddress(classNameEncoded);
        }
        WNDCLASSEX.className(wndclassex, l);
    }

    public static void iconSm(ByteBuffer wndclassex, long iconSm) {
        PointerBuffer.put(wndclassex, wndclassex.position() + ICONSM, iconSm);
    }

    public static int size(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + SIZE);
    }

    public static int style(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + STYLE);
    }

    public static long wndProc(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + WNDPROC);
    }

    public static int clsExtra(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + CLSEXTRA);
    }

    public static int wndExtra(ByteBuffer wndclassex) {
        return wndclassex.getInt(wndclassex.position() + WNDEXTRA);
    }

    public static long instance(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + INSTANCE);
    }

    public static long icon(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + ICON);
    }

    public static long cursor(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + CURSOR);
    }

    public static long background(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + BACKGROUND);
    }

    public static long menuName(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + MENUNAME);
    }

    public static ByteBuffer menuNameGetb(ByteBuffer wndclassex) {
        long address = WNDCLASSEX.menuName(wndclassex);
        return address == 0L ? null : MemoryUtil.memByteBufferNT2(address);
    }

    public static String menuNameGets(ByteBuffer wndclassex) {
        long address = WNDCLASSEX.menuName(wndclassex);
        return address == 0L ? null : MemoryUtil.memDecodeUTF16(address);
    }

    public static long className(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + CLASSNAME);
    }

    public static ByteBuffer classNameGetb(ByteBuffer wndclassex) {
        long address = WNDCLASSEX.className(wndclassex);
        return address == 0L ? null : MemoryUtil.memByteBufferNT2(address);
    }

    public static String classNameGets(ByteBuffer wndclassex) {
        long address = WNDCLASSEX.className(wndclassex);
        return address == 0L ? null : MemoryUtil.memDecodeUTF16(address);
    }

    public static long iconSm(ByteBuffer wndclassex) {
        return PointerBuffer.get(wndclassex, wndclassex.position() + ICONSM);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(12);
        SIZEOF = WNDCLASSEX.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        STYLE = offsets.get(1);
        WNDPROC = offsets.get(2);
        CLSEXTRA = offsets.get(3);
        WNDEXTRA = offsets.get(4);
        INSTANCE = offsets.get(5);
        ICON = offsets.get(6);
        CURSOR = offsets.get(7);
        BACKGROUND = offsets.get(8);
        MENUNAME = offsets.get(9);
        CLASSNAME = offsets.get(10);
        ICONSM = offsets.get(11);
    }
}

