/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class WINDOWPOS {
    public static final int SIZEOF;
    public static final int HWND;
    public static final int HWNDINSERTAFTER;
    public static final int X;
    public static final int Y;
    public static final int CX;
    public static final int CY;
    public static final int FLAGS;

    private WINDOWPOS() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long hwnd, long hwndInsertAfter, int x, int y, int cx, int cy, int flags) {
        ByteBuffer windowpos = WINDOWPOS.malloc();
        WINDOWPOS.hwnd(windowpos, hwnd);
        WINDOWPOS.hwndInsertAfter(windowpos, hwndInsertAfter);
        WINDOWPOS.x(windowpos, x);
        WINDOWPOS.y(windowpos, y);
        WINDOWPOS.cx(windowpos, cx);
        WINDOWPOS.cy(windowpos, cy);
        WINDOWPOS.flags(windowpos, flags);
        return windowpos;
    }

    public static void hwnd(ByteBuffer windowpos, long hwnd) {
        PointerBuffer.put(windowpos, windowpos.position() + HWND, hwnd);
    }

    public static void hwndInsertAfter(ByteBuffer windowpos, long hwndInsertAfter) {
        PointerBuffer.put(windowpos, windowpos.position() + HWNDINSERTAFTER, hwndInsertAfter);
    }

    public static void x(ByteBuffer windowpos, int x) {
        windowpos.putInt(windowpos.position() + X, x);
    }

    public static void y(ByteBuffer windowpos, int y) {
        windowpos.putInt(windowpos.position() + Y, y);
    }

    public static void cx(ByteBuffer windowpos, int cx) {
        windowpos.putInt(windowpos.position() + CX, cx);
    }

    public static void cy(ByteBuffer windowpos, int cy) {
        windowpos.putInt(windowpos.position() + CY, cy);
    }

    public static void flags(ByteBuffer windowpos, int flags) {
        windowpos.putInt(windowpos.position() + FLAGS, flags);
    }

    public static long hwnd(ByteBuffer windowpos) {
        return PointerBuffer.get(windowpos, windowpos.position() + HWND);
    }

    public static long hwndInsertAfter(ByteBuffer windowpos) {
        return PointerBuffer.get(windowpos, windowpos.position() + HWNDINSERTAFTER);
    }

    public static int x(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + X);
    }

    public static int y(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + Y);
    }

    public static int cx(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + CX);
    }

    public static int cy(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + CY);
    }

    public static int flags(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + FLAGS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(7);
        SIZEOF = WINDOWPOS.offsets(MemoryUtil.memAddress(offsets));
        HWND = offsets.get(0);
        HWNDINSERTAFTER = offsets.get(1);
        X = offsets.get(2);
        Y = offsets.get(3);
        CX = offsets.get(4);
        CY = offsets.get(5);
        FLAGS = offsets.get(6);
    }
}

