/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public final class RECT {
    public static final int SIZEOF;
    public static final int LEFT;
    public static final int TOP;
    public static final int RIGHT;
    public static final int BOTTOM;

    private RECT() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int left, int top, int right, int bottom) {
        ByteBuffer rect = RECT.malloc();
        RECT.left(rect, left);
        RECT.top(rect, top);
        RECT.right(rect, right);
        RECT.bottom(rect, bottom);
        return rect;
    }

    public static void left(ByteBuffer rect, int left) {
        rect.putInt(rect.position() + LEFT, left);
    }

    public static void top(ByteBuffer rect, int top) {
        rect.putInt(rect.position() + TOP, top);
    }

    public static void right(ByteBuffer rect, int right) {
        rect.putInt(rect.position() + RIGHT, right);
    }

    public static void bottom(ByteBuffer rect, int bottom) {
        rect.putInt(rect.position() + BOTTOM, bottom);
    }

    public static int left(ByteBuffer rect) {
        return rect.getInt(rect.position() + LEFT);
    }

    public static int top(ByteBuffer rect) {
        return rect.getInt(rect.position() + TOP);
    }

    public static int right(ByteBuffer rect) {
        return rect.getInt(rect.position() + RIGHT);
    }

    public static int bottom(ByteBuffer rect) {
        return rect.getInt(rect.position() + BOTTOM);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = RECT.offsets(MemoryUtil.memAddress(offsets));
        LEFT = offsets.get(0);
        TOP = offsets.get(1);
        RIGHT = offsets.get(2);
        BOTTOM = offsets.get(3);
    }
}

