/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class OSVERSIONINFOEX {
    public static final int SIZEOF;
    public static final int OSVERSIONINFOSIZE;
    public static final int MAJORVERSION;
    public static final int MINORVERSION;
    public static final int BUILDNUMBER;
    public static final int PLATFORMID;
    public static final int CSDVERSION;
    public static final int SERVICEPACKMAJOR;
    public static final int SERVICEPACKMINOR;
    public static final int SUITEMASK;
    public static final int PRODUCTTYPE;

    private OSVERSIONINFOEX() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int osVersionInfoSize, int majorVersion, int minorVersion, int buildNumber, int platformId, long csdVersion, int csdVersionBytes, int servicePackMajor, int servicePackMinor, int suiteMask, int productType) {
        ByteBuffer osversioninfoex = OSVERSIONINFOEX.malloc();
        OSVERSIONINFOEX.osVersionInfoSize(osversioninfoex, osVersionInfoSize);
        OSVERSIONINFOEX.majorVersion(osversioninfoex, majorVersion);
        OSVERSIONINFOEX.minorVersion(osversioninfoex, minorVersion);
        OSVERSIONINFOEX.buildNumber(osversioninfoex, buildNumber);
        OSVERSIONINFOEX.platformId(osversioninfoex, platformId);
        OSVERSIONINFOEX.csdVersionSet(osversioninfoex, csdVersion, csdVersionBytes);
        OSVERSIONINFOEX.servicePackMajor(osversioninfoex, servicePackMajor);
        OSVERSIONINFOEX.servicePackMinor(osversioninfoex, servicePackMinor);
        OSVERSIONINFOEX.suiteMask(osversioninfoex, suiteMask);
        OSVERSIONINFOEX.productType(osversioninfoex, productType);
        return osversioninfoex;
    }

    public static ByteBuffer malloc(int osVersionInfoSize, int majorVersion, int minorVersion, int buildNumber, int platformId, ByteBuffer csdVersion, int servicePackMajor, int servicePackMinor, int suiteMask, int productType) {
        ByteBuffer osversioninfoex = OSVERSIONINFOEX.malloc();
        OSVERSIONINFOEX.osVersionInfoSize(osversioninfoex, osVersionInfoSize);
        OSVERSIONINFOEX.majorVersion(osversioninfoex, majorVersion);
        OSVERSIONINFOEX.minorVersion(osversioninfoex, minorVersion);
        OSVERSIONINFOEX.buildNumber(osversioninfoex, buildNumber);
        OSVERSIONINFOEX.platformId(osversioninfoex, platformId);
        OSVERSIONINFOEX.csdVersionSet(osversioninfoex, csdVersion);
        OSVERSIONINFOEX.servicePackMajor(osversioninfoex, servicePackMajor);
        OSVERSIONINFOEX.servicePackMinor(osversioninfoex, servicePackMinor);
        OSVERSIONINFOEX.suiteMask(osversioninfoex, suiteMask);
        OSVERSIONINFOEX.productType(osversioninfoex, productType);
        return osversioninfoex;
    }

    public static ByteBuffer malloc(int osVersionInfoSize, int majorVersion, int minorVersion, int buildNumber, int platformId, CharSequence csdVersion, int servicePackMajor, int servicePackMinor, int suiteMask, int productType) {
        ByteBuffer osversioninfoex = OSVERSIONINFOEX.malloc();
        OSVERSIONINFOEX.osVersionInfoSize(osversioninfoex, osVersionInfoSize);
        OSVERSIONINFOEX.majorVersion(osversioninfoex, majorVersion);
        OSVERSIONINFOEX.minorVersion(osversioninfoex, minorVersion);
        OSVERSIONINFOEX.buildNumber(osversioninfoex, buildNumber);
        OSVERSIONINFOEX.platformId(osversioninfoex, platformId);
        OSVERSIONINFOEX.csdVersionSet(osversioninfoex, csdVersion);
        OSVERSIONINFOEX.servicePackMajor(osversioninfoex, servicePackMajor);
        OSVERSIONINFOEX.servicePackMinor(osversioninfoex, servicePackMinor);
        OSVERSIONINFOEX.suiteMask(osversioninfoex, suiteMask);
        OSVERSIONINFOEX.productType(osversioninfoex, productType);
        return osversioninfoex;
    }

    public static void osVersionInfoSize(ByteBuffer osversioninfoex, int osVersionInfoSize) {
        osversioninfoex.putInt(osversioninfoex.position() + OSVERSIONINFOSIZE, osVersionInfoSize);
    }

    public static void majorVersion(ByteBuffer osversioninfoex, int majorVersion) {
        osversioninfoex.putInt(osversioninfoex.position() + MAJORVERSION, majorVersion);
    }

    public static void minorVersion(ByteBuffer osversioninfoex, int minorVersion) {
        osversioninfoex.putInt(osversioninfoex.position() + MINORVERSION, minorVersion);
    }

    public static void buildNumber(ByteBuffer osversioninfoex, int buildNumber) {
        osversioninfoex.putInt(osversioninfoex.position() + BUILDNUMBER, buildNumber);
    }

    public static void platformId(ByteBuffer osversioninfoex, int platformId) {
        osversioninfoex.putInt(osversioninfoex.position() + PLATFORMID, platformId);
    }

    public static void csdVersionSet(ByteBuffer osversioninfoex, long csdVersion, int bytes) {
        MemoryUtil.memCopy(csdVersion, MemoryUtil.memAddress(osversioninfoex) + (long)CSDVERSION, bytes);
    }

    public static void csdVersionSet(ByteBuffer osversioninfoex, ByteBuffer csdVersion) {
        Checks.checkNT2(csdVersion);
        Checks.checkBufferGT(csdVersion, 256);
        OSVERSIONINFOEX.csdVersionSet(osversioninfoex, MemoryUtil.memAddress(csdVersion), csdVersion.remaining());
    }

    public static void csdVersionSet(ByteBuffer osversioninfoex, CharSequence csdVersion) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(csdVersion, true);
        OSVERSIONINFOEX.csdVersionSet(osversioninfoex, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void servicePackMajor(ByteBuffer osversioninfoex, int servicePackMajor) {
        osversioninfoex.putShort(osversioninfoex.position() + SERVICEPACKMAJOR, (short)servicePackMajor);
    }

    public static void servicePackMinor(ByteBuffer osversioninfoex, int servicePackMinor) {
        osversioninfoex.putShort(osversioninfoex.position() + SERVICEPACKMINOR, (short)servicePackMinor);
    }

    public static void suiteMask(ByteBuffer osversioninfoex, int suiteMask) {
        osversioninfoex.putShort(osversioninfoex.position() + SUITEMASK, (short)suiteMask);
    }

    public static void productType(ByteBuffer osversioninfoex, int productType) {
        osversioninfoex.put(osversioninfoex.position() + PRODUCTTYPE, (byte)productType);
    }

    public static int osVersionInfoSize(ByteBuffer osversioninfoex) {
        return osversioninfoex.getInt(osversioninfoex.position() + OSVERSIONINFOSIZE);
    }

    public static int majorVersion(ByteBuffer osversioninfoex) {
        return osversioninfoex.getInt(osversioninfoex.position() + MAJORVERSION);
    }

    public static int minorVersion(ByteBuffer osversioninfoex) {
        return osversioninfoex.getInt(osversioninfoex.position() + MINORVERSION);
    }

    public static int buildNumber(ByteBuffer osversioninfoex) {
        return osversioninfoex.getInt(osversioninfoex.position() + BUILDNUMBER);
    }

    public static int platformId(ByteBuffer osversioninfoex) {
        return osversioninfoex.getInt(osversioninfoex.position() + PLATFORMID);
    }

    public static void csdVersionGet(ByteBuffer osversioninfoex, long csdVersion, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(osversioninfoex) + (long)CSDVERSION, csdVersion, bytes);
    }

    public static void csdVersionGet(ByteBuffer osversioninfoex, ByteBuffer csdVersion) {
        Checks.checkBufferGT(csdVersion, 256);
        OSVERSIONINFOEX.csdVersionGet(osversioninfoex, MemoryUtil.memAddress(csdVersion), csdVersion.remaining());
    }

    public static String csdVersionGets(ByteBuffer osversioninfoex) {
        return MemoryUtil.memDecodeUTF16(osversioninfoex, MemoryUtil.memStrLen2(osversioninfoex, CSDVERSION), CSDVERSION);
    }

    public static String csdVersionGets(ByteBuffer osversioninfoex, int size) {
        return MemoryUtil.memDecodeUTF16(osversioninfoex, size, CSDVERSION);
    }

    public static int servicePackMajor(ByteBuffer osversioninfoex) {
        return osversioninfoex.getShort(osversioninfoex.position() + SERVICEPACKMAJOR);
    }

    public static int servicePackMinor(ByteBuffer osversioninfoex) {
        return osversioninfoex.getShort(osversioninfoex.position() + SERVICEPACKMINOR);
    }

    public static int suiteMask(ByteBuffer osversioninfoex) {
        return osversioninfoex.getShort(osversioninfoex.position() + SUITEMASK);
    }

    public static int productType(ByteBuffer osversioninfoex) {
        return osversioninfoex.get(osversioninfoex.position() + PRODUCTTYPE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(10);
        SIZEOF = OSVERSIONINFOEX.offsets(MemoryUtil.memAddress(offsets));
        OSVERSIONINFOSIZE = offsets.get(0);
        MAJORVERSION = offsets.get(1);
        MINORVERSION = offsets.get(2);
        BUILDNUMBER = offsets.get(3);
        PLATFORMID = offsets.get(4);
        CSDVERSION = offsets.get(5);
        SERVICEPACKMAJOR = offsets.get(6);
        SERVICEPACKMINOR = offsets.get(7);
        SUITEMASK = offsets.get(8);
        PRODUCTTYPE = offsets.get(9);
    }
}

