/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINT;

public final class MSG {
    public static final int SIZEOF;
    public static final int WINDOW;
    public static final int MESSAGE;
    public static final int WPARAM;
    public static final int LPARAM;
    public static final int TIME;
    public static final int POINT;

    private MSG() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long window, int message, long wParam, long lParam, int time, long point) {
        ByteBuffer msg = MSG.malloc();
        MSG.window(msg, window);
        MSG.message(msg, message);
        MSG.wParam(msg, wParam);
        MSG.lParam(msg, lParam);
        MSG.time(msg, time);
        MSG.pointSet(msg, point);
        return msg;
    }

    public static ByteBuffer malloc(long window, int message, long wParam, long lParam, int time, ByteBuffer point) {
        ByteBuffer msg = MSG.malloc();
        MSG.window(msg, window);
        MSG.message(msg, message);
        MSG.wParam(msg, wParam);
        MSG.lParam(msg, lParam);
        MSG.time(msg, time);
        MSG.pointSet(msg, point);
        return msg;
    }

    public static void window(ByteBuffer msg, long window) {
        PointerBuffer.put(msg, msg.position() + WINDOW, window);
    }

    public static void message(ByteBuffer msg, int message) {
        msg.putInt(msg.position() + MESSAGE, message);
    }

    public static void wParam(ByteBuffer msg, long wParam) {
        PointerBuffer.put(msg, msg.position() + WPARAM, wParam);
    }

    public static void lParam(ByteBuffer msg, long lParam) {
        PointerBuffer.put(msg, msg.position() + LPARAM, lParam);
    }

    public static void time(ByteBuffer msg, int time) {
        msg.putInt(msg.position() + TIME, time);
    }

    public static void pointSet(ByteBuffer msg, long point) {
        if (point != 0L) {
            MemoryUtil.memCopy(point, MemoryUtil.memAddress(msg) + (long)POINT, org.lwjgl.system.windows.POINT.SIZEOF);
        }
    }

    public static void pointSet(ByteBuffer msg, ByteBuffer point) {
        MSG.pointSet(msg, MemoryUtil.memAddressSafe(point));
    }

    public static void pointX(ByteBuffer msg, int x) {
        msg.putInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.X, x);
    }

    public static void pointY(ByteBuffer msg, int y) {
        msg.putInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.Y, y);
    }

    public static long window(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + WINDOW);
    }

    public static int message(ByteBuffer msg) {
        return msg.getInt(msg.position() + MESSAGE);
    }

    public static long wParam(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + WPARAM);
    }

    public static long lParam(ByteBuffer msg) {
        return PointerBuffer.get(msg, msg.position() + LPARAM);
    }

    public static int time(ByteBuffer msg) {
        return msg.getInt(msg.position() + TIME);
    }

    public static void pointGet(ByteBuffer msg, long point) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(msg) + (long)POINT, point, org.lwjgl.system.windows.POINT.SIZEOF);
    }

    public static void pointGet(ByteBuffer msg, ByteBuffer point) {
        Checks.checkBuffer((Buffer)point, org.lwjgl.system.windows.POINT.SIZEOF);
        MSG.pointGet(msg, MemoryUtil.memAddress(point));
    }

    public static int pointX(ByteBuffer msg) {
        return msg.getInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.X);
    }

    public static int pointY(ByteBuffer msg) {
        return msg.getInt(msg.position() + POINT + org.lwjgl.system.windows.POINT.Y);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = MSG.offsets(MemoryUtil.memAddress(offsets));
        WINDOW = offsets.get(0);
        MESSAGE = offsets.get(1);
        WPARAM = offsets.get(2);
        LPARAM = offsets.get(3);
        TIME = offsets.get(4);
        POINT = offsets.get(5);
    }
}

