/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINT;

public final class LOGPEN {
    public static final int SIZEOF;
    public static final int LOPNSTYLE;
    public static final int LOPNWIDTH;
    public static final int LOPNCOLOR;

    private LOGPEN() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int lopnStyle, long lopnWidth, int lopnColor) {
        ByteBuffer logpen = LOGPEN.malloc();
        LOGPEN.lopnStyle(logpen, lopnStyle);
        LOGPEN.lopnWidthSet(logpen, lopnWidth);
        LOGPEN.lopnColor(logpen, lopnColor);
        return logpen;
    }

    public static ByteBuffer malloc(int lopnStyle, ByteBuffer lopnWidth, int lopnColor) {
        ByteBuffer logpen = LOGPEN.malloc();
        LOGPEN.lopnStyle(logpen, lopnStyle);
        LOGPEN.lopnWidthSet(logpen, lopnWidth);
        LOGPEN.lopnColor(logpen, lopnColor);
        return logpen;
    }

    public static void lopnStyle(ByteBuffer logpen, int lopnStyle) {
        logpen.putInt(logpen.position() + LOPNSTYLE, lopnStyle);
    }

    public static void lopnWidthSet(ByteBuffer logpen, long lopnWidth) {
        if (lopnWidth != 0L) {
            MemoryUtil.memCopy(lopnWidth, MemoryUtil.memAddress(logpen) + (long)LOPNWIDTH, POINT.SIZEOF);
        }
    }

    public static void lopnWidthSet(ByteBuffer logpen, ByteBuffer lopnWidth) {
        LOGPEN.lopnWidthSet(logpen, MemoryUtil.memAddressSafe(lopnWidth));
    }

    public static void lopnWidthX(ByteBuffer logpen, int x) {
        logpen.putInt(logpen.position() + LOPNWIDTH + POINT.X, x);
    }

    public static void lopnWidthY(ByteBuffer logpen, int y) {
        logpen.putInt(logpen.position() + LOPNWIDTH + POINT.Y, y);
    }

    public static void lopnColor(ByteBuffer logpen, int lopnColor) {
        logpen.putInt(logpen.position() + LOPNCOLOR, lopnColor);
    }

    public static int lopnStyle(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNSTYLE);
    }

    public static void lopnWidthGet(ByteBuffer logpen, long lopnWidth) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(logpen) + (long)LOPNWIDTH, lopnWidth, POINT.SIZEOF);
    }

    public static void lopnWidthGet(ByteBuffer logpen, ByteBuffer lopnWidth) {
        Checks.checkBuffer((Buffer)lopnWidth, POINT.SIZEOF);
        LOGPEN.lopnWidthGet(logpen, MemoryUtil.memAddress(lopnWidth));
    }

    public static int lopnWidthX(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNWIDTH + POINT.X);
    }

    public static int lopnWidthY(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNWIDTH + POINT.Y);
    }

    public static int lopnColor(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNCOLOR);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = LOGPEN.offsets(MemoryUtil.memAddress(offsets));
        LOPNSTYLE = offsets.get(0);
        LOPNWIDTH = offsets.get(1);
        LOPNCOLOR = offsets.get(2);
    }
}

