/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public final class JOYINFO {
    public static final int SIZEOF;
    public static final int XPOS;
    public static final int YPOS;
    public static final int ZPOS;
    public static final int BUTTONS;

    private JOYINFO() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int xPos, int yPos, int zPos, int buttons) {
        ByteBuffer joyinfo = JOYINFO.malloc();
        JOYINFO.xPos(joyinfo, xPos);
        JOYINFO.yPos(joyinfo, yPos);
        JOYINFO.zPos(joyinfo, zPos);
        JOYINFO.buttons(joyinfo, buttons);
        return joyinfo;
    }

    public static void xPos(ByteBuffer joyinfo, int xPos) {
        joyinfo.putInt(joyinfo.position() + XPOS, xPos);
    }

    public static void yPos(ByteBuffer joyinfo, int yPos) {
        joyinfo.putInt(joyinfo.position() + YPOS, yPos);
    }

    public static void zPos(ByteBuffer joyinfo, int zPos) {
        joyinfo.putInt(joyinfo.position() + ZPOS, zPos);
    }

    public static void buttons(ByteBuffer joyinfo, int buttons) {
        joyinfo.putInt(joyinfo.position() + BUTTONS, buttons);
    }

    public static int xPos(ByteBuffer joyinfo) {
        return joyinfo.getInt(joyinfo.position() + XPOS);
    }

    public static int yPos(ByteBuffer joyinfo) {
        return joyinfo.getInt(joyinfo.position() + YPOS);
    }

    public static int zPos(ByteBuffer joyinfo) {
        return joyinfo.getInt(joyinfo.position() + ZPOS);
    }

    public static int buttons(ByteBuffer joyinfo) {
        return joyinfo.getInt(joyinfo.position() + BUTTONS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = JOYINFO.offsets(MemoryUtil.memAddress(offsets));
        XPOS = offsets.get(0);
        YPOS = offsets.get(1);
        ZPOS = offsets.get(2);
        BUTTONS = offsets.get(3);
    }
}

