/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINTFLOAT;

public final class GLYPHMETRICSFLOAT {
    public static final int SIZEOF;
    public static final int BLACKBOXX;
    public static final int BLOCKBOXY;
    public static final int GLYPHORIGIN;
    public static final int CELLINCX;
    public static final int CELLINCY;

    private GLYPHMETRICSFLOAT() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(float blackBoxX, float blockBoxY, long glyphOrigin, float cellIncX, float cellIncY) {
        ByteBuffer glyphmetricsfloat = GLYPHMETRICSFLOAT.malloc();
        GLYPHMETRICSFLOAT.blackBoxX(glyphmetricsfloat, blackBoxX);
        GLYPHMETRICSFLOAT.blockBoxY(glyphmetricsfloat, blockBoxY);
        GLYPHMETRICSFLOAT.glyphOriginSet(glyphmetricsfloat, glyphOrigin);
        GLYPHMETRICSFLOAT.cellIncX(glyphmetricsfloat, cellIncX);
        GLYPHMETRICSFLOAT.cellIncY(glyphmetricsfloat, cellIncY);
        return glyphmetricsfloat;
    }

    public static ByteBuffer malloc(float blackBoxX, float blockBoxY, ByteBuffer glyphOrigin, float cellIncX, float cellIncY) {
        ByteBuffer glyphmetricsfloat = GLYPHMETRICSFLOAT.malloc();
        GLYPHMETRICSFLOAT.blackBoxX(glyphmetricsfloat, blackBoxX);
        GLYPHMETRICSFLOAT.blockBoxY(glyphmetricsfloat, blockBoxY);
        GLYPHMETRICSFLOAT.glyphOriginSet(glyphmetricsfloat, glyphOrigin);
        GLYPHMETRICSFLOAT.cellIncX(glyphmetricsfloat, cellIncX);
        GLYPHMETRICSFLOAT.cellIncY(glyphmetricsfloat, cellIncY);
        return glyphmetricsfloat;
    }

    public static void blackBoxX(ByteBuffer glyphmetricsfloat, float blackBoxX) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + BLACKBOXX, blackBoxX);
    }

    public static void blockBoxY(ByteBuffer glyphmetricsfloat, float blockBoxY) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + BLOCKBOXY, blockBoxY);
    }

    public static void glyphOriginSet(ByteBuffer glyphmetricsfloat, long glyphOrigin) {
        if (glyphOrigin != 0L) {
            MemoryUtil.memCopy(glyphOrigin, MemoryUtil.memAddress(glyphmetricsfloat) + (long)GLYPHORIGIN, POINTFLOAT.SIZEOF);
        }
    }

    public static void glyphOriginSet(ByteBuffer glyphmetricsfloat, ByteBuffer glyphOrigin) {
        GLYPHMETRICSFLOAT.glyphOriginSet(glyphmetricsfloat, MemoryUtil.memAddressSafe(glyphOrigin));
    }

    public static void glyphOriginX(ByteBuffer glyphmetricsfloat, float x) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.X, x);
    }

    public static void glyphOriginY(ByteBuffer glyphmetricsfloat, float y) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.Y, y);
    }

    public static void cellIncX(ByteBuffer glyphmetricsfloat, float cellIncX) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + CELLINCX, cellIncX);
    }

    public static void cellIncY(ByteBuffer glyphmetricsfloat, float cellIncY) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + CELLINCY, cellIncY);
    }

    public static float blackBoxX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + BLACKBOXX);
    }

    public static float blockBoxY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + BLOCKBOXY);
    }

    public static void glyphOriginGet(ByteBuffer glyphmetricsfloat, long glyphOrigin) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(glyphmetricsfloat) + (long)GLYPHORIGIN, glyphOrigin, POINTFLOAT.SIZEOF);
    }

    public static void glyphOriginGet(ByteBuffer glyphmetricsfloat, ByteBuffer glyphOrigin) {
        Checks.checkBuffer((Buffer)glyphOrigin, POINTFLOAT.SIZEOF);
        GLYPHMETRICSFLOAT.glyphOriginGet(glyphmetricsfloat, MemoryUtil.memAddress(glyphOrigin));
    }

    public static float glyphOriginX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.X);
    }

    public static float glyphOriginY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.Y);
    }

    public static float cellIncX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + CELLINCX);
    }

    public static float cellIncY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + CELLINCY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = GLYPHMETRICSFLOAT.offsets(MemoryUtil.memAddress(offsets));
        BLACKBOXX = offsets.get(0);
        BLOCKBOXY = offsets.get(1);
        GLYPHORIGIN = offsets.get(2);
        CELLINCX = offsets.get(3);
        CELLINCY = offsets.get(4);
    }
}

