/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class DISPLAY_DEVICE {
    public static final int SIZEOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int STATEFLAGS;
    public static final int DEVICEID;
    public static final int DEVICEKEY;

    private DISPLAY_DEVICE() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int cb, long DeviceName, int DeviceNameBytes, long DeviceString, int DeviceStringBytes, int StateFlags, long DeviceID, int DeviceIDBytes, long DeviceKey, int DeviceKeyBytes) {
        ByteBuffer display_device = DISPLAY_DEVICE.malloc();
        DISPLAY_DEVICE.cb(display_device, cb);
        DISPLAY_DEVICE.DeviceNameSet(display_device, DeviceName, DeviceNameBytes);
        DISPLAY_DEVICE.DeviceStringSet(display_device, DeviceString, DeviceStringBytes);
        DISPLAY_DEVICE.StateFlags(display_device, StateFlags);
        DISPLAY_DEVICE.DeviceIDSet(display_device, DeviceID, DeviceIDBytes);
        DISPLAY_DEVICE.DeviceKeySet(display_device, DeviceKey, DeviceKeyBytes);
        return display_device;
    }

    public static ByteBuffer malloc(int cb, ByteBuffer DeviceName, ByteBuffer DeviceString, int StateFlags, ByteBuffer DeviceID, ByteBuffer DeviceKey) {
        ByteBuffer display_device = DISPLAY_DEVICE.malloc();
        DISPLAY_DEVICE.cb(display_device, cb);
        DISPLAY_DEVICE.DeviceNameSet(display_device, DeviceName);
        DISPLAY_DEVICE.DeviceStringSet(display_device, DeviceString);
        DISPLAY_DEVICE.StateFlags(display_device, StateFlags);
        DISPLAY_DEVICE.DeviceIDSet(display_device, DeviceID);
        DISPLAY_DEVICE.DeviceKeySet(display_device, DeviceKey);
        return display_device;
    }

    public static ByteBuffer malloc(int cb, CharSequence DeviceName, CharSequence DeviceString, int StateFlags, CharSequence DeviceID, CharSequence DeviceKey) {
        ByteBuffer display_device = DISPLAY_DEVICE.malloc();
        DISPLAY_DEVICE.cb(display_device, cb);
        DISPLAY_DEVICE.DeviceNameSet(display_device, DeviceName);
        DISPLAY_DEVICE.DeviceStringSet(display_device, DeviceString);
        DISPLAY_DEVICE.StateFlags(display_device, StateFlags);
        DISPLAY_DEVICE.DeviceIDSet(display_device, DeviceID);
        DISPLAY_DEVICE.DeviceKeySet(display_device, DeviceKey);
        return display_device;
    }

    public static void cb(ByteBuffer display_device, int cb) {
        display_device.putInt(display_device.position() + CB, cb);
    }

    public static void DeviceNameSet(ByteBuffer display_device, long DeviceName, int bytes) {
        MemoryUtil.memCopy(DeviceName, MemoryUtil.memAddress(display_device) + (long)DEVICENAME, bytes);
    }

    public static void DeviceNameSet(ByteBuffer display_device, ByteBuffer DeviceName) {
        Checks.checkNT2(DeviceName);
        Checks.checkBufferGT(DeviceName, 64);
        DISPLAY_DEVICE.DeviceNameSet(display_device, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static void DeviceNameSet(ByteBuffer display_device, CharSequence DeviceName) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceName, true);
        DISPLAY_DEVICE.DeviceNameSet(display_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void DeviceStringSet(ByteBuffer display_device, long DeviceString, int bytes) {
        MemoryUtil.memCopy(DeviceString, MemoryUtil.memAddress(display_device) + (long)DEVICESTRING, bytes);
    }

    public static void DeviceStringSet(ByteBuffer display_device, ByteBuffer DeviceString) {
        Checks.checkNT2(DeviceString);
        Checks.checkBufferGT(DeviceString, 256);
        DISPLAY_DEVICE.DeviceStringSet(display_device, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static void DeviceStringSet(ByteBuffer display_device, CharSequence DeviceString) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceString, true);
        DISPLAY_DEVICE.DeviceStringSet(display_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void StateFlags(ByteBuffer display_device, int StateFlags) {
        display_device.putInt(display_device.position() + STATEFLAGS, StateFlags);
    }

    public static void DeviceIDSet(ByteBuffer display_device, long DeviceID, int bytes) {
        MemoryUtil.memCopy(DeviceID, MemoryUtil.memAddress(display_device) + (long)DEVICEID, bytes);
    }

    public static void DeviceIDSet(ByteBuffer display_device, ByteBuffer DeviceID) {
        Checks.checkNT2(DeviceID);
        Checks.checkBufferGT(DeviceID, 256);
        DISPLAY_DEVICE.DeviceIDSet(display_device, MemoryUtil.memAddress(DeviceID), DeviceID.remaining());
    }

    public static void DeviceIDSet(ByteBuffer display_device, CharSequence DeviceID) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceID, true);
        DISPLAY_DEVICE.DeviceIDSet(display_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void DeviceKeySet(ByteBuffer display_device, long DeviceKey, int bytes) {
        MemoryUtil.memCopy(DeviceKey, MemoryUtil.memAddress(display_device) + (long)DEVICEKEY, bytes);
    }

    public static void DeviceKeySet(ByteBuffer display_device, ByteBuffer DeviceKey) {
        Checks.checkNT2(DeviceKey);
        Checks.checkBufferGT(DeviceKey, 256);
        DISPLAY_DEVICE.DeviceKeySet(display_device, MemoryUtil.memAddress(DeviceKey), DeviceKey.remaining());
    }

    public static void DeviceKeySet(ByteBuffer display_device, CharSequence DeviceKey) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceKey, true);
        DISPLAY_DEVICE.DeviceKeySet(display_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static int cb(ByteBuffer display_device) {
        return display_device.getInt(display_device.position() + CB);
    }

    public static void DeviceNameGet(ByteBuffer display_device, long DeviceName, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICENAME, DeviceName, bytes);
    }

    public static void DeviceNameGet(ByteBuffer display_device, ByteBuffer DeviceName) {
        Checks.checkBufferGT(DeviceName, 64);
        DISPLAY_DEVICE.DeviceNameGet(display_device, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static String DeviceNameGets(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICENAME), DEVICENAME);
    }

    public static String DeviceNameGets(ByteBuffer display_device, int size) {
        return MemoryUtil.memDecodeUTF16(display_device, size, DEVICENAME);
    }

    public static void DeviceStringGet(ByteBuffer display_device, long DeviceString, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICESTRING, DeviceString, bytes);
    }

    public static void DeviceStringGet(ByteBuffer display_device, ByteBuffer DeviceString) {
        Checks.checkBufferGT(DeviceString, 256);
        DISPLAY_DEVICE.DeviceStringGet(display_device, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static String DeviceStringGets(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICESTRING), DEVICESTRING);
    }

    public static String DeviceStringGets(ByteBuffer display_device, int size) {
        return MemoryUtil.memDecodeUTF16(display_device, size, DEVICESTRING);
    }

    public static int StateFlags(ByteBuffer display_device) {
        return display_device.getInt(display_device.position() + STATEFLAGS);
    }

    public static void DeviceIDGet(ByteBuffer display_device, long DeviceID, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICEID, DeviceID, bytes);
    }

    public static void DeviceIDGet(ByteBuffer display_device, ByteBuffer DeviceID) {
        Checks.checkBufferGT(DeviceID, 256);
        DISPLAY_DEVICE.DeviceIDGet(display_device, MemoryUtil.memAddress(DeviceID), DeviceID.remaining());
    }

    public static String DeviceIDGets(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICEID), DEVICEID);
    }

    public static String DeviceIDGets(ByteBuffer display_device, int size) {
        return MemoryUtil.memDecodeUTF16(display_device, size, DEVICEID);
    }

    public static void DeviceKeyGet(ByteBuffer display_device, long DeviceKey, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICEKEY, DeviceKey, bytes);
    }

    public static void DeviceKeyGet(ByteBuffer display_device, ByteBuffer DeviceKey) {
        Checks.checkBufferGT(DeviceKey, 256);
        DISPLAY_DEVICE.DeviceKeyGet(display_device, MemoryUtil.memAddress(DeviceKey), DeviceKey.remaining());
    }

    public static String DeviceKeyGets(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICEKEY), DEVICEKEY);
    }

    public static String DeviceKeyGets(ByteBuffer display_device, int size) {
        return MemoryUtil.memDecodeUTF16(display_device, size, DEVICEKEY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = DISPLAY_DEVICE.offsets(MemoryUtil.memAddress(offsets));
        CB = offsets.get(0);
        DEVICENAME = offsets.get(1);
        DEVICESTRING = offsets.get(2);
        STATEFLAGS = offsets.get(3);
        DEVICEID = offsets.get(4);
        DEVICEKEY = offsets.get(5);
    }
}

