/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINTL;

public final class DEVMODE {
    public static final int SIZEOF;
    public static final int DEVICENAME;
    public static final int SPECVERSION;
    public static final int DRIVERVERSION;
    public static final int SIZE;
    public static final int DRIVEREXTRA;
    public static final int FIELDS;
    public static final int POSITION;
    public static final int LOGPIXELS;
    public static final int BITSPERPEL;
    public static final int PELSWIDTH;
    public static final int PELSHEIGHT;
    public static final int DISPLAYFLAGS;
    public static final int DISPLAYFREQUENCY;

    private DEVMODE() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long deviceName, int deviceNameBytes, int specVersion, int driverVersion, int size, int driverExtra, int fields, long position, int logPixels, int bitsPerPel, int pelsWidth, int pelsHeight, int displayFlags, int displayFrequency) {
        ByteBuffer devmode = DEVMODE.malloc();
        DEVMODE.deviceNameSet(devmode, deviceName, deviceNameBytes);
        DEVMODE.specVersion(devmode, specVersion);
        DEVMODE.driverVersion(devmode, driverVersion);
        DEVMODE.size(devmode, size);
        DEVMODE.driverExtra(devmode, driverExtra);
        DEVMODE.fields(devmode, fields);
        DEVMODE.positionSet(devmode, position);
        DEVMODE.logPixels(devmode, logPixels);
        DEVMODE.bitsPerPel(devmode, bitsPerPel);
        DEVMODE.pelsWidth(devmode, pelsWidth);
        DEVMODE.pelsHeight(devmode, pelsHeight);
        DEVMODE.displayFlags(devmode, displayFlags);
        DEVMODE.displayFrequency(devmode, displayFrequency);
        return devmode;
    }

    public static ByteBuffer malloc(ByteBuffer deviceName, int specVersion, int driverVersion, int size, int driverExtra, int fields, ByteBuffer position, int logPixels, int bitsPerPel, int pelsWidth, int pelsHeight, int displayFlags, int displayFrequency) {
        ByteBuffer devmode = DEVMODE.malloc();
        DEVMODE.deviceNameSet(devmode, deviceName);
        DEVMODE.specVersion(devmode, specVersion);
        DEVMODE.driverVersion(devmode, driverVersion);
        DEVMODE.size(devmode, size);
        DEVMODE.driverExtra(devmode, driverExtra);
        DEVMODE.fields(devmode, fields);
        DEVMODE.positionSet(devmode, position);
        DEVMODE.logPixels(devmode, logPixels);
        DEVMODE.bitsPerPel(devmode, bitsPerPel);
        DEVMODE.pelsWidth(devmode, pelsWidth);
        DEVMODE.pelsHeight(devmode, pelsHeight);
        DEVMODE.displayFlags(devmode, displayFlags);
        DEVMODE.displayFrequency(devmode, displayFrequency);
        return devmode;
    }

    public static ByteBuffer malloc(CharSequence deviceName, int specVersion, int driverVersion, int size, int driverExtra, int fields, ByteBuffer position, int logPixels, int bitsPerPel, int pelsWidth, int pelsHeight, int displayFlags, int displayFrequency) {
        ByteBuffer devmode = DEVMODE.malloc();
        DEVMODE.deviceNameSet(devmode, deviceName);
        DEVMODE.specVersion(devmode, specVersion);
        DEVMODE.driverVersion(devmode, driverVersion);
        DEVMODE.size(devmode, size);
        DEVMODE.driverExtra(devmode, driverExtra);
        DEVMODE.fields(devmode, fields);
        DEVMODE.positionSet(devmode, position);
        DEVMODE.logPixels(devmode, logPixels);
        DEVMODE.bitsPerPel(devmode, bitsPerPel);
        DEVMODE.pelsWidth(devmode, pelsWidth);
        DEVMODE.pelsHeight(devmode, pelsHeight);
        DEVMODE.displayFlags(devmode, displayFlags);
        DEVMODE.displayFrequency(devmode, displayFrequency);
        return devmode;
    }

    public static void deviceNameSet(ByteBuffer devmode, long deviceName, int bytes) {
        MemoryUtil.memCopy(deviceName, MemoryUtil.memAddress(devmode) + (long)DEVICENAME, bytes);
    }

    public static void deviceNameSet(ByteBuffer devmode, ByteBuffer deviceName) {
        Checks.checkNT2(deviceName);
        Checks.checkBufferGT(deviceName, 64);
        DEVMODE.deviceNameSet(devmode, MemoryUtil.memAddress(deviceName), deviceName.remaining());
    }

    public static void deviceNameSet(ByteBuffer devmode, CharSequence deviceName) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(deviceName, true);
        DEVMODE.deviceNameSet(devmode, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void specVersion(ByteBuffer devmode, int specVersion) {
        devmode.putShort(devmode.position() + SPECVERSION, (short)specVersion);
    }

    public static void driverVersion(ByteBuffer devmode, int driverVersion) {
        devmode.putShort(devmode.position() + DRIVERVERSION, (short)driverVersion);
    }

    public static void size(ByteBuffer devmode, int size) {
        devmode.putShort(devmode.position() + SIZE, (short)size);
    }

    public static void driverExtra(ByteBuffer devmode, int driverExtra) {
        devmode.putShort(devmode.position() + DRIVEREXTRA, (short)driverExtra);
    }

    public static void fields(ByteBuffer devmode, int fields) {
        devmode.putInt(devmode.position() + FIELDS, fields);
    }

    public static void positionSet(ByteBuffer devmode, long position) {
        if (position != 0L) {
            MemoryUtil.memCopy(position, MemoryUtil.memAddress(devmode) + (long)POSITION, POINTL.SIZEOF);
        }
    }

    public static void positionSet(ByteBuffer devmode, ByteBuffer position) {
        DEVMODE.positionSet(devmode, MemoryUtil.memAddressSafe(position));
    }

    public static void positionX(ByteBuffer devmode, int x) {
        devmode.putInt(devmode.position() + POSITION + POINTL.X, x);
    }

    public static void positionY(ByteBuffer devmode, int y) {
        devmode.putInt(devmode.position() + POSITION + POINTL.Y, y);
    }

    public static void logPixels(ByteBuffer devmode, int logPixels) {
        devmode.putShort(devmode.position() + LOGPIXELS, (short)logPixels);
    }

    public static void bitsPerPel(ByteBuffer devmode, int bitsPerPel) {
        devmode.putInt(devmode.position() + BITSPERPEL, bitsPerPel);
    }

    public static void pelsWidth(ByteBuffer devmode, int pelsWidth) {
        devmode.putInt(devmode.position() + PELSWIDTH, pelsWidth);
    }

    public static void pelsHeight(ByteBuffer devmode, int pelsHeight) {
        devmode.putInt(devmode.position() + PELSHEIGHT, pelsHeight);
    }

    public static void displayFlags(ByteBuffer devmode, int displayFlags) {
        devmode.putInt(devmode.position() + DISPLAYFLAGS, displayFlags);
    }

    public static void displayFrequency(ByteBuffer devmode, int displayFrequency) {
        devmode.putInt(devmode.position() + DISPLAYFREQUENCY, displayFrequency);
    }

    public static void deviceNameGet(ByteBuffer devmode, long deviceName, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(devmode) + (long)DEVICENAME, deviceName, bytes);
    }

    public static void deviceNameGet(ByteBuffer devmode, ByteBuffer deviceName) {
        Checks.checkBufferGT(deviceName, 64);
        DEVMODE.deviceNameGet(devmode, MemoryUtil.memAddress(deviceName), deviceName.remaining());
    }

    public static String deviceNameGets(ByteBuffer devmode) {
        return MemoryUtil.memDecodeUTF16(devmode, MemoryUtil.memStrLen2(devmode, DEVICENAME), DEVICENAME);
    }

    public static String deviceNameGets(ByteBuffer devmode, int size) {
        return MemoryUtil.memDecodeUTF16(devmode, size, DEVICENAME);
    }

    public static int specVersion(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + SPECVERSION);
    }

    public static int driverVersion(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + DRIVERVERSION);
    }

    public static int size(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + SIZE);
    }

    public static int driverExtra(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + DRIVEREXTRA);
    }

    public static int fields(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + FIELDS);
    }

    public static void positionGet(ByteBuffer devmode, long position) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(devmode) + (long)POSITION, position, POINTL.SIZEOF);
    }

    public static void positionGet(ByteBuffer devmode, ByteBuffer position) {
        Checks.checkBuffer((Buffer)position, POINTL.SIZEOF);
        DEVMODE.positionGet(devmode, MemoryUtil.memAddress(position));
    }

    public static int positionX(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + POSITION + POINTL.X);
    }

    public static int positionY(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + POSITION + POINTL.Y);
    }

    public static int logPixels(ByteBuffer devmode) {
        return devmode.getShort(devmode.position() + LOGPIXELS);
    }

    public static int bitsPerPel(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + BITSPERPEL);
    }

    public static int pelsWidth(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + PELSWIDTH);
    }

    public static int pelsHeight(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + PELSHEIGHT);
    }

    public static int displayFlags(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + DISPLAYFLAGS);
    }

    public static int displayFrequency(ByteBuffer devmode) {
        return devmode.getInt(devmode.position() + DISPLAYFREQUENCY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(13);
        SIZEOF = DEVMODE.offsets(MemoryUtil.memAddress(offsets));
        DEVICENAME = offsets.get(0);
        SPECVERSION = offsets.get(1);
        DRIVERVERSION = offsets.get(2);
        SIZE = offsets.get(3);
        DRIVEREXTRA = offsets.get(4);
        FIELDS = offsets.get(5);
        POSITION = offsets.get(6);
        LOGPIXELS = offsets.get(7);
        BITSPERPEL = offsets.get(8);
        PELSWIDTH = offsets.get(9);
        PELSHEIGHT = offsets.get(10);
        DISPLAYFLAGS = offsets.get(11);
        DISPLAYFREQUENCY = offsets.get(12);
    }
}

