/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx.opengl;

import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.system.macosx.CGL;

public class MacOSXGLContext
extends GLContext {
    private final long handle;

    public MacOSXGLContext(ContextCapabilities capabilities, long handle) {
        super(capabilities);
        this.handle = handle;
    }

    @Override
    public long getPointer() {
        return this.handle;
    }

    @Override
    protected void makeCurrentImpl(long target) {
        CGL.CGLSetCurrentContext(this.handle);
    }

    @Override
    protected void makeCurrentImpl(long targetDraw, long targetRead) {
        CGL.CGLSetCurrentContext(this.handle);
    }

    @Override
    public boolean isCurrent() {
        return CGL.CGLGetCurrentContext() == this.handle;
    }

    public static MacOSXGLContext createFromCurrent() {
        ContextCapabilities capabilities = GL.createCapabilities(false);
        return new MacOSXGLContext(capabilities, CGL.CGLGetCurrentContext());
    }

    @Override
    protected void destroyImpl() {
        CGL.CGLDestroyContext(this.handle);
    }
}

