/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.macosx.CoreFoundation;
import org.lwjgl.system.macosx.MacOSXLibrary;

public class MacOSXLibraryBundle
extends MacOSXLibrary {
    private final long bundleRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacOSXLibraryBundle(String name) {
        super(name);
        long fsPath = 0L;
        long url = 0L;
        try {
            fsPath = CoreFoundation.CFStringCreateWithCStringNoCopy(0L, MemoryUtil.memEncodeASCII(name), 1536, CoreFoundation.kCFAllocatorNull());
            if (fsPath == 0L) {
                throw new NullPointerException();
            }
            url = CoreFoundation.CFURLCreateWithFileSystemPath(0L, fsPath, 0L, (byte)1);
            if (url == 0L) {
                throw new NullPointerException();
            }
            this.bundleRef = CoreFoundation.CFBundleCreate(0L, url);
            if (this.bundleRef == 0L) {
                throw new RuntimeException("Failed to dynamically load bundle: " + name);
            }
        }
        finally {
            if (url != 0L) {
                CoreFoundation.CFRelease(url);
            }
            if (fsPath != 0L) {
                CoreFoundation.CFRelease(fsPath);
            }
        }
    }

    @Override
    public long getPointer() {
        return this.bundleRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFunctionAddress(ByteBuffer name) {
        long nameRef = CoreFoundation.CFStringCreateWithCStringNoCopy(0L, name, 1536, CoreFoundation.kCFAllocatorNull());
        if (nameRef == 0L) {
            throw new NullPointerException();
        }
        try {
            long l = CoreFoundation.CFBundleGetFunctionPointerForName(this.bundleRef, nameRef);
            return l;
        }
        finally {
            CoreFoundation.CFRelease(nameRef);
        }
    }

    @Override
    protected void destroy() {
        CoreFoundation.CFRelease(this.bundleRef);
    }
}

