/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class timespec {
    public static final int SIZEOF;
    public static final int SEC;
    public static final int NSEC;

    private timespec() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long sec, long nsec) {
        ByteBuffer timespec2 = timespec.malloc();
        timespec.sec(timespec2, sec);
        timespec.nsec(timespec2, nsec);
        return timespec2;
    }

    public static void sec(ByteBuffer timespec2, long sec) {
        timespec2.putLong(timespec2.position() + SEC, sec);
    }

    public static void nsec(ByteBuffer timespec2, long nsec) {
        PointerBuffer.put(timespec2, timespec2.position() + NSEC, nsec);
    }

    public static long sec(ByteBuffer timespec2) {
        return timespec2.getLong(timespec2.position() + SEC);
    }

    public static long nsec(ByteBuffer timespec2) {
        return PointerBuffer.get(timespec2, timespec2.position() + NSEC);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = timespec.offsets(MemoryUtil.memAddress(offsets));
        SEC = offsets.get(0);
        NSEC = offsets.get(1);
    }
}

