/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XComposeStatus;
import org.lwjgl.system.linux.XKeyEvent;
import org.lwjgl.system.linux.XSizeHints;
import org.lwjgl.system.linux.XWMHints;

public final class Xutil {
    public static final int InputHint = 1;
    public static final int StateHint = 2;
    public static final int IconPixmapHint = 4;
    public static final int IconWindowHint = 8;
    public static final int IconPositionHint = 16;
    public static final int IconMaskHint = 32;
    public static final int WindowGroupHint = 64;
    public static final int AllHints = 127;
    public static final int XUrgencyHint = 256;
    public static final int WithdrawnState = 0;
    public static final int NormalState = 1;
    public static final int IconicState = 3;
    public static final int USPosition = 1;
    public static final int USSize = 2;
    public static final int PPosition = 4;
    public static final int PSize = 8;
    public static final int PMinSize = 16;
    public static final int PMaxSize = 32;
    public static final int PResizeInc = 64;
    public static final int PAspect = 128;
    public static final int PBaseSize = 256;
    public static final int PWinGravity = 512;

    private Xutil() {
    }

    public static native int nXLookupString(long var0, long var2, int var4, long var5, long var7);

    public static int XLookupString(ByteBuffer event_struct, ByteBuffer buffer_return, int bytes_buffer, ByteBuffer keysym_return, ByteBuffer status_in_out) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)event_struct, XKeyEvent.SIZEOF);
            Checks.checkBuffer((Buffer)buffer_return, bytes_buffer);
            Checks.checkBuffer((Buffer)status_in_out, XComposeStatus.SIZEOF);
        }
        return Xutil.nXLookupString(MemoryUtil.memAddress(event_struct), MemoryUtil.memAddress(buffer_return), bytes_buffer, MemoryUtil.memAddress(keysym_return), MemoryUtil.memAddress(status_in_out));
    }

    public static int XLookupString(ByteBuffer event_struct, ByteBuffer buffer_return, PointerBuffer keysym_return, ByteBuffer status_in_out) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)event_struct, XKeyEvent.SIZEOF);
            Checks.checkBuffer((Buffer)status_in_out, XComposeStatus.SIZEOF);
        }
        return Xutil.nXLookupString(MemoryUtil.memAddress(event_struct), MemoryUtil.memAddress(buffer_return), buffer_return.remaining(), MemoryUtil.memAddress(keysym_return), MemoryUtil.memAddress(status_in_out));
    }

    public static native long nXAllocWMHints();

    public static ByteBuffer XAllocWMHints() {
        long __result = Xutil.nXAllocWMHints();
        return MemoryUtil.memByteBuffer(__result, XWMHints.SIZEOF);
    }

    public static native long nXAllocSizeHints();

    public static ByteBuffer XAllocSizeHints() {
        long __result = Xutil.nXAllocSizeHints();
        return MemoryUtil.memByteBuffer(__result, XSizeHints.SIZEOF);
    }

    public static native int XUniqueContext();

    public static native int nXSaveContext(long var0, long var2, int var4, long var5);

    public static int XSaveContext(long display, long rid, int context, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xutil.nXSaveContext(display, rid, context, MemoryUtil.memAddress(data));
    }

    public static native int nXFindContext(long var0, long var2, int var4, long var5);

    public static int XFindContext(long display, long rid, int context, ByteBuffer data_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xutil.nXFindContext(display, rid, context, MemoryUtil.memAddress(data_return));
    }

    public static int XFindContext(long display, long rid, int context, PointerBuffer data_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xutil.nXFindContext(display, rid, context, MemoryUtil.memAddress(data_return));
    }

    public static native int nXDeleteContext(long var0, long var2, int var4);

    public static int XDeleteContext(long display, long rid, int context) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xutil.nXDeleteContext(display, rid, context);
    }

    static {
        Sys.touch();
    }
}

