/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XEvent;
import org.lwjgl.system.linux.XRRCrtcGamma;
import org.lwjgl.system.linux.XRRCrtcInfo;
import org.lwjgl.system.linux.XRROutputInfo;
import org.lwjgl.system.linux.XRRScreenResources;

public final class Xrandr {
    public static final int RRScreenChangeNotifyMask = 1;
    public static final int RRCrtcChangeNotifyMask = 2;
    public static final int RROutputChangeNotifyMask = 4;
    public static final int RROutputPropertyNotifyMask = 8;
    public static final int RRScreenChangeNotify = 0;
    public static final int RRNotify = 1;
    public static final int RRNotify_CrtcChange = 0;
    public static final int RRNotify_OutputChange = 1;
    public static final int RRNotify_OutputProperty = 2;
    public static final short RR_Rotate_0 = 1;
    public static final short RR_Rotate_90 = 2;
    public static final short RR_Rotate_180 = 4;
    public static final short RR_Rotate_270 = 8;
    public static final short RR_Reflect_X = 16;
    public static final short RR_Reflect_Y = 32;
    public static final int RRSetConfigSuccess = 0;
    public static final int RRSetConfigInvalidConfigTime = 1;
    public static final int RRSetConfigInvalidTime = 2;
    public static final int RRSetConfigFailed = 3;
    public static final int RR_Connected = 0;
    public static final int RR_Disconnected = 1;
    public static final int RR_UnknownConnection = 2;
    public static final int BadRROutput = 0;
    public static final int BadRRCrtc = 1;
    public static final int BadRRMode = 2;
    public static final int RR_HSyncPositive = 1;
    public static final int RR_HSyncNegative = 2;
    public static final int RR_VSyncPositive = 4;
    public static final int RR_VSyncNegative = 8;
    public static final int RR_Interlace = 16;
    public static final int RR_DoubleScan = 32;
    public static final int RR_CSync = 64;
    public static final int RR_CSyncPositive = 128;
    public static final int RR_CSyncNegative = 256;
    public static final int RR_HSkewPresent = 512;
    public static final int RR_BCast = 1024;
    public static final int RR_PixelMultiplex = 2048;
    public static final int RR_DoubleClock = 4096;
    public static final int RR_ClockDivideBy2 = 8192;

    private Xrandr() {
    }

    public static native int nXRRQueryExtension(long var0, long var2, long var4);

    public static int XRRQueryExtension(long display, ByteBuffer event_base_return, ByteBuffer error_base_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_base_return, 4);
            Checks.checkBuffer((Buffer)error_base_return, 4);
        }
        return Xrandr.nXRRQueryExtension(display, MemoryUtil.memAddress(event_base_return), MemoryUtil.memAddress(error_base_return));
    }

    public static int XRRQueryExtension(long display, IntBuffer event_base_return, IntBuffer error_base_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_base_return, 1);
            Checks.checkBuffer((Buffer)error_base_return, 1);
        }
        return Xrandr.nXRRQueryExtension(display, MemoryUtil.memAddress(event_base_return), MemoryUtil.memAddress(error_base_return));
    }

    public static native int nXRRQueryVersion(long var0, long var2, long var4);

    public static int XRRQueryVersion(long display, ByteBuffer major_version_return, ByteBuffer minor_version_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major_version_return, 4);
            Checks.checkBuffer((Buffer)minor_version_return, 4);
        }
        return Xrandr.nXRRQueryVersion(display, MemoryUtil.memAddress(major_version_return), MemoryUtil.memAddress(minor_version_return));
    }

    public static int XRRQueryVersion(long display, IntBuffer major_version_return, IntBuffer minor_version_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major_version_return, 1);
            Checks.checkBuffer((Buffer)minor_version_return, 1);
        }
        return Xrandr.nXRRQueryVersion(display, MemoryUtil.memAddress(major_version_return), MemoryUtil.memAddress(minor_version_return));
    }

    public static native long nXRRGetScreenResources(long var0, long var2);

    public static ByteBuffer XRRGetScreenResources(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        long __result = Xrandr.nXRRGetScreenResources(display, w);
        return MemoryUtil.memByteBuffer(__result, XRRScreenResources.SIZEOF);
    }

    public static native void nXRRFreeScreenResources(long var0);

    public static void XRRFreeScreenResources(ByteBuffer resources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)resources, XRRScreenResources.SIZEOF);
        }
        Xrandr.nXRRFreeScreenResources(MemoryUtil.memAddress(resources));
    }

    public static native long nXRRGetOutputPrimary(long var0, long var2);

    public static long XRRGetOutputPrimary(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xrandr.nXRRGetOutputPrimary(display, w);
    }

    public static native long nXRRGetCrtcInfo(long var0, long var2, long var4);

    public static ByteBuffer XRRGetCrtcInfo(long display, ByteBuffer resources, long crtc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)resources, XRRScreenResources.SIZEOF);
        }
        long __result = Xrandr.nXRRGetCrtcInfo(display, MemoryUtil.memAddress(resources), crtc);
        return MemoryUtil.memByteBuffer(__result, XRRCrtcInfo.SIZEOF);
    }

    public static native void nXRRFreeCrtcInfo(long var0);

    public static void XRRFreeCrtcInfo(ByteBuffer crtcInfo) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)crtcInfo, XRRCrtcInfo.SIZEOF);
        }
        Xrandr.nXRRFreeCrtcInfo(MemoryUtil.memAddress(crtcInfo));
    }

    public static native long nXRRGetOutputInfo(long var0, long var2, long var4);

    public static ByteBuffer XRRGetOutputInfo(long display, ByteBuffer resources, long output) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)resources, XRRScreenResources.SIZEOF);
        }
        long __result = Xrandr.nXRRGetOutputInfo(display, MemoryUtil.memAddress(resources), output);
        return MemoryUtil.memByteBuffer(__result, XRROutputInfo.SIZEOF);
    }

    public static native void nXRRFreeOutputInfo(long var0);

    public static void XRRFreeOutputInfo(ByteBuffer outputInfo) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)outputInfo, XRROutputInfo.SIZEOF);
        }
        Xrandr.nXRRFreeOutputInfo(MemoryUtil.memAddress(outputInfo));
    }

    public static native void nXRRSelectInput(long var0, long var2, int var4);

    public static void XRRSelectInput(long display, long w, int mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        Xrandr.nXRRSelectInput(display, w, mask);
    }

    public static native int nXRRSetCrtcConfig(long var0, long var2, long var4, long var6, int var8, int var9, long var10, short var12, long var13, int var15);

    public static int XRRSetCrtcConfig(long display, ByteBuffer resources, long crtc, long timestamp, int x, int y, long mode, short rotation, ByteBuffer outputs, int noutputs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)resources, XRRScreenResources.SIZEOF);
            Checks.checkBuffer((Buffer)outputs, noutputs << Pointer.POINTER_SHIFT);
        }
        return Xrandr.nXRRSetCrtcConfig(display, MemoryUtil.memAddress(resources), crtc, timestamp, x, y, mode, rotation, MemoryUtil.memAddress(outputs), noutputs);
    }

    public static int XRRSetCrtcConfig(long display, ByteBuffer resources, long crtc, long timestamp, int x, int y, long mode, short rotation, PointerBuffer outputs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)resources, XRRScreenResources.SIZEOF);
        }
        return Xrandr.nXRRSetCrtcConfig(display, MemoryUtil.memAddress(resources), crtc, timestamp, x, y, mode, rotation, MemoryUtil.memAddress(outputs), outputs.remaining());
    }

    public static native int nXRRUpdateConfiguration(long var0);

    public static int XRRUpdateConfiguration(ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)event, XEvent.SIZEOF);
        }
        return Xrandr.nXRRUpdateConfiguration(MemoryUtil.memAddress(event));
    }

    public static native int nXRRGetCrtcGammaSize(long var0, long var2);

    public static int XRRGetCrtcGammaSize(long display, long crtc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xrandr.nXRRGetCrtcGammaSize(display, crtc);
    }

    public static native long nXRRGetCrtcGamma(long var0, long var2);

    public static ByteBuffer XRRGetCrtcGamma(long display, long crtc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        long __result = Xrandr.nXRRGetCrtcGamma(display, crtc);
        return MemoryUtil.memByteBuffer(__result, XRRCrtcGamma.SIZEOF);
    }

    public static native long nXRRAllocGamma(int var0);

    public static ByteBuffer XRRAllocGamma(int size) {
        long __result = Xrandr.nXRRAllocGamma(size);
        return MemoryUtil.memByteBuffer(__result, XRRCrtcGamma.SIZEOF);
    }

    public static native void nXRRFreeGamma(long var0);

    public static void XRRFreeGamma(ByteBuffer gamma) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)gamma, XRRCrtcGamma.SIZEOF);
        }
        Xrandr.nXRRFreeGamma(MemoryUtil.memAddress(gamma));
    }

    public static native void nXRRSetCrtcGamma(long var0, long var2, long var4);

    public static void XRRSetCrtcGamma(long display, long crtc, ByteBuffer gamma) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)gamma, XRRCrtcGamma.SIZEOF);
        }
        Xrandr.nXRRSetCrtcGamma(display, crtc, MemoryUtil.memAddress(gamma));
    }

    static {
        Sys.touch();
    }
}

